/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.stygene;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.stygene.StyGene;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.stygene.StyGeneAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.stygene.StyGeneDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class StyGeneImpl
extends DatabaseCrossReferenceImpl
implements StyGene,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.STYGENE;
    private long id = 0L;
    private StyGeneAccessionNumber styGeneAccessionNumber = DefaultXRefFactory.getInstance().buildStyGeneAccessionNumber("");
    private StyGeneDescription styGeneDescription = DefaultXRefFactory.getInstance().buildStyGeneDescription("");

    public StyGeneImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getStyGeneAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public StyGeneImpl(StyGeneImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasStyGeneAccessionNumber()) {
            this.setStyGeneAccessionNumber(toCopy.getStyGeneAccessionNumber());
        }
        if (toCopy.hasStyGeneDescription()) {
            this.setStyGeneDescription(toCopy.getStyGeneDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof StyGeneImpl)) {
            return false;
        }
        StyGeneImpl myClass = (StyGeneImpl)o;
        if (!this.styGeneAccessionNumber.equals(myClass.getStyGeneAccessionNumber())) {
            return false;
        }
        return this.styGeneDescription.equals(myClass.getStyGeneDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.styGeneAccessionNumber != null ? this.styGeneAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.styGeneDescription != null ? this.styGeneDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.styGeneAccessionNumber + ":" + this.styGeneDescription + ";";
    }

    @Override
    public StyGeneAccessionNumber getStyGeneAccessionNumber() {
        return this.styGeneAccessionNumber;
    }

    @Override
    public void setStyGeneAccessionNumber(StyGeneAccessionNumber styGeneAccessionNumber) {
        if (styGeneAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.styGeneAccessionNumber = styGeneAccessionNumber;
    }

    @Override
    public boolean hasStyGeneAccessionNumber() {
        return !this.styGeneAccessionNumber.getValue().equals("");
    }

    @Override
    public StyGeneDescription getStyGeneDescription() {
        return this.styGeneDescription;
    }

    @Override
    public void setStyGeneDescription(StyGeneDescription styGeneDescription) {
        if (styGeneDescription == null) {
            throw new IllegalArgumentException();
        }
        this.styGeneDescription = styGeneDescription;
    }

    @Override
    public boolean hasStyGeneDescription() {
        return !this.styGeneDescription.getValue().equals("");
    }
}

