/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.smr;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smr.Smr;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smr.SmrAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smr.SmrDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class SmrImpl
extends DatabaseCrossReferenceImpl
implements Smr,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.SMR;
    private long id = 0L;
    private SmrAccessionNumber smrAccessionNumber = DefaultXRefFactory.getInstance().buildSmrAccessionNumber("");
    private SmrDescription smrDescription = DefaultXRefFactory.getInstance().buildSmrDescription("");

    public SmrImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getSmrAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public SmrImpl(SmrImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasSmrAccessionNumber()) {
            this.setSmrAccessionNumber(toCopy.getSmrAccessionNumber());
        }
        if (toCopy.hasSmrDescription()) {
            this.setSmrDescription(toCopy.getSmrDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmrImpl)) {
            return false;
        }
        SmrImpl myClass = (SmrImpl)o;
        if (!this.smrAccessionNumber.equals(myClass.getSmrAccessionNumber())) {
            return false;
        }
        return this.smrDescription.equals(myClass.getSmrDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.smrAccessionNumber != null ? this.smrAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.smrDescription != null ? this.smrDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.smrAccessionNumber + ":" + this.smrDescription + ";";
    }

    @Override
    public SmrAccessionNumber getSmrAccessionNumber() {
        return this.smrAccessionNumber;
    }

    @Override
    public void setSmrAccessionNumber(SmrAccessionNumber smrAccessionNumber) {
        if (smrAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.smrAccessionNumber = smrAccessionNumber;
    }

    @Override
    public boolean hasSmrAccessionNumber() {
        return !this.smrAccessionNumber.getValue().equals("");
    }

    @Override
    public SmrDescription getSmrDescription() {
        return this.smrDescription;
    }

    @Override
    public void setSmrDescription(SmrDescription smrDescription) {
        if (smrDescription == null) {
            throw new IllegalArgumentException();
        }
        this.smrDescription = smrDescription;
    }

    @Override
    public boolean hasSmrDescription() {
        return !this.smrDescription.getValue().equals("");
    }
}

