/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.smart;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smart.Smart;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smart.SmartAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smart.SmartDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.smart.SmartHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class SmartImpl
extends DatabaseCrossReferenceImpl
implements Smart,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.SMART;
    private long id = 0L;
    private SmartAccessionNumber smartAccessionNumber = DefaultXRefFactory.getInstance().buildSmartAccessionNumber("");
    private SmartDescription smartDescription = DefaultXRefFactory.getInstance().buildSmartDescription("");
    private SmartHitNumber smartHitNumber = DefaultXRefFactory.getInstance().buildSmartHitNumber("");

    public SmartImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getSmartAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public SmartImpl(SmartImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasSmartAccessionNumber()) {
            this.setSmartAccessionNumber(toCopy.getSmartAccessionNumber());
        }
        if (toCopy.hasSmartDescription()) {
            this.setSmartDescription(toCopy.getSmartDescription());
        }
        if (toCopy.hasSmartHitNumber()) {
            this.setSmartHitNumber(toCopy.getSmartHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmartImpl)) {
            return false;
        }
        SmartImpl myClass = (SmartImpl)o;
        if (!this.smartAccessionNumber.equals(myClass.getSmartAccessionNumber())) {
            return false;
        }
        if (!this.smartDescription.equals(myClass.getSmartDescription())) {
            return false;
        }
        return this.smartHitNumber.equals(myClass.getSmartHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.smartAccessionNumber != null ? this.smartAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.smartDescription != null ? this.smartDescription.hashCode() : 0);
        result = 29 * result + (this.smartHitNumber != null ? this.smartHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.smartAccessionNumber + ":" + this.smartDescription + ":" + this.smartHitNumber + ";";
    }

    @Override
    public SmartAccessionNumber getSmartAccessionNumber() {
        return this.smartAccessionNumber;
    }

    @Override
    public void setSmartAccessionNumber(SmartAccessionNumber smartAccessionNumber) {
        if (smartAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.smartAccessionNumber = smartAccessionNumber;
    }

    @Override
    public boolean hasSmartAccessionNumber() {
        return !this.smartAccessionNumber.getValue().equals("");
    }

    @Override
    public SmartDescription getSmartDescription() {
        return this.smartDescription;
    }

    @Override
    public void setSmartDescription(SmartDescription smartDescription) {
        if (smartDescription == null) {
            throw new IllegalArgumentException();
        }
        this.smartDescription = smartDescription;
    }

    @Override
    public boolean hasSmartDescription() {
        return !this.smartDescription.getValue().equals("");
    }

    @Override
    public SmartHitNumber getSmartHitNumber() {
        return this.smartHitNumber;
    }

    @Override
    public void setSmartHitNumber(SmartHitNumber smartHitNumber) {
        if (smartHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.smartHitNumber = smartHitNumber;
    }

    @Override
    public boolean hasSmartHitNumber() {
        return !this.smartHitNumber.getValue().equals("");
    }
}

