/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.sgd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.sgd.Sgd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.sgd.SgdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.sgd.SgdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class SgdImpl
extends DatabaseCrossReferenceImpl
implements Sgd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.SGD;
    private long id = 0L;
    private SgdAccessionNumber sgdAccessionNumber = DefaultXRefFactory.getInstance().buildSgdAccessionNumber("");
    private SgdDescription sgdDescription = DefaultXRefFactory.getInstance().buildSgdDescription("");

    public SgdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getSgdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public SgdImpl(SgdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasSgdAccessionNumber()) {
            this.setSgdAccessionNumber(toCopy.getSgdAccessionNumber());
        }
        if (toCopy.hasSgdDescription()) {
            this.setSgdDescription(toCopy.getSgdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SgdImpl)) {
            return false;
        }
        SgdImpl myClass = (SgdImpl)o;
        if (!this.sgdAccessionNumber.equals(myClass.getSgdAccessionNumber())) {
            return false;
        }
        return this.sgdDescription.equals(myClass.getSgdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.sgdAccessionNumber != null ? this.sgdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.sgdDescription != null ? this.sgdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.sgdAccessionNumber + ":" + this.sgdDescription + ";";
    }

    @Override
    public SgdAccessionNumber getSgdAccessionNumber() {
        return this.sgdAccessionNumber;
    }

    @Override
    public void setSgdAccessionNumber(SgdAccessionNumber sgdAccessionNumber) {
        if (sgdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.sgdAccessionNumber = sgdAccessionNumber;
    }

    @Override
    public boolean hasSgdAccessionNumber() {
        return !this.sgdAccessionNumber.getValue().equals("");
    }

    @Override
    public SgdDescription getSgdDescription() {
        return this.sgdDescription;
    }

    @Override
    public void setSgdDescription(SgdDescription sgdDescription) {
        if (sgdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.sgdDescription = sgdDescription;
    }

    @Override
    public boolean hasSgdDescription() {
        return !this.sgdDescription.getValue().equals("");
    }
}

