/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.rgd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rgd.Rgd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rgd.RgdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rgd.RgdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class RgdImpl
extends DatabaseCrossReferenceImpl
implements Rgd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.RGD;
    private long id = 0L;
    private RgdAccessionNumber rgdAccessionNumber = DefaultXRefFactory.getInstance().buildRgdAccessionNumber("");
    private RgdDescription rgdDescription = DefaultXRefFactory.getInstance().buildRgdDescription("");

    public RgdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getRgdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public RgdImpl(RgdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasRgdAccessionNumber()) {
            this.setRgdAccessionNumber(toCopy.getRgdAccessionNumber());
        }
        if (toCopy.hasRgdDescription()) {
            this.setRgdDescription(toCopy.getRgdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof RgdImpl)) {
            return false;
        }
        RgdImpl myClass = (RgdImpl)o;
        if (!this.rgdAccessionNumber.equals(myClass.getRgdAccessionNumber())) {
            return false;
        }
        return this.rgdDescription.equals(myClass.getRgdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.rgdAccessionNumber != null ? this.rgdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.rgdDescription != null ? this.rgdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.rgdAccessionNumber + ":" + this.rgdDescription + ";";
    }

    @Override
    public RgdAccessionNumber getRgdAccessionNumber() {
        return this.rgdAccessionNumber;
    }

    @Override
    public void setRgdAccessionNumber(RgdAccessionNumber rgdAccessionNumber) {
        if (rgdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.rgdAccessionNumber = rgdAccessionNumber;
    }

    @Override
    public boolean hasRgdAccessionNumber() {
        return !this.rgdAccessionNumber.getValue().equals("");
    }

    @Override
    public RgdDescription getRgdDescription() {
        return this.rgdDescription;
    }

    @Override
    public void setRgdDescription(RgdDescription rgdDescription) {
        if (rgdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.rgdDescription = rgdDescription;
    }

    @Override
    public boolean hasRgdDescription() {
        return !this.rgdDescription.getValue().equals("");
    }
}

