/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.refseq;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.refseq.RefSeq;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.refseq.RefSeqAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.refseq.RefSeqDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class RefSeqImpl
extends DatabaseCrossReferenceImpl
implements RefSeq,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.REFSEQ;
    private long id = 0L;
    private RefSeqAccessionNumber refSeqAccessionNumber = DefaultXRefFactory.getInstance().buildRefSeqAccessionNumber("");
    private RefSeqDescription refSeqDescription = DefaultXRefFactory.getInstance().buildRefSeqDescription("");

    public RefSeqImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getRefSeqAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public RefSeqImpl(RefSeqImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasRefSeqAccessionNumber()) {
            this.setRefSeqAccessionNumber(toCopy.getRefSeqAccessionNumber());
        }
        if (toCopy.hasRefSeqDescription()) {
            this.setRefSeqDescription(toCopy.getRefSeqDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof RefSeqImpl)) {
            return false;
        }
        RefSeqImpl myClass = (RefSeqImpl)o;
        if (!this.refSeqAccessionNumber.equals(myClass.getRefSeqAccessionNumber())) {
            return false;
        }
        return this.refSeqDescription.equals(myClass.getRefSeqDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.refSeqAccessionNumber != null ? this.refSeqAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.refSeqDescription != null ? this.refSeqDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.refSeqAccessionNumber + ":" + this.refSeqDescription + ";";
    }

    @Override
    public RefSeqAccessionNumber getRefSeqAccessionNumber() {
        return this.refSeqAccessionNumber;
    }

    @Override
    public void setRefSeqAccessionNumber(RefSeqAccessionNumber refSeqAccessionNumber) {
        if (refSeqAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.refSeqAccessionNumber = refSeqAccessionNumber;
    }

    @Override
    public boolean hasRefSeqAccessionNumber() {
        return !this.refSeqAccessionNumber.getValue().equals("");
    }

    @Override
    public RefSeqDescription getRefSeqDescription() {
        return this.refSeqDescription;
    }

    @Override
    public void setRefSeqDescription(RefSeqDescription refSeqDescription) {
        if (refSeqDescription == null) {
            throw new IllegalArgumentException();
        }
        this.refSeqDescription = refSeqDescription;
    }

    @Override
    public boolean hasRefSeqDescription() {
        return !this.refSeqDescription.getValue().equals("");
    }
}

