/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.rebase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rebase.Rebase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rebase.RebaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.rebase.RebaseDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class RebaseImpl
extends DatabaseCrossReferenceImpl
implements Rebase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.REBASE;
    private long id = 0L;
    private RebaseAccessionNumber rebaseAccessionNumber = DefaultXRefFactory.getInstance().buildRebaseAccessionNumber("");
    private RebaseDescription rebaseDescription = DefaultXRefFactory.getInstance().buildRebaseDescription("");

    public RebaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getRebaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public RebaseImpl(RebaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasRebaseAccessionNumber()) {
            this.setRebaseAccessionNumber(toCopy.getRebaseAccessionNumber());
        }
        if (toCopy.hasRebaseDescription()) {
            this.setRebaseDescription(toCopy.getRebaseDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof RebaseImpl)) {
            return false;
        }
        RebaseImpl myClass = (RebaseImpl)o;
        if (!this.rebaseAccessionNumber.equals(myClass.getRebaseAccessionNumber())) {
            return false;
        }
        return this.rebaseDescription.equals(myClass.getRebaseDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.rebaseAccessionNumber != null ? this.rebaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.rebaseDescription != null ? this.rebaseDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.rebaseAccessionNumber + ":" + this.rebaseDescription + ";";
    }

    @Override
    public RebaseAccessionNumber getRebaseAccessionNumber() {
        return this.rebaseAccessionNumber;
    }

    @Override
    public void setRebaseAccessionNumber(RebaseAccessionNumber rebaseAccessionNumber) {
        if (rebaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.rebaseAccessionNumber = rebaseAccessionNumber;
    }

    @Override
    public boolean hasRebaseAccessionNumber() {
        return !this.rebaseAccessionNumber.getValue().equals("");
    }

    @Override
    public RebaseDescription getRebaseDescription() {
        return this.rebaseDescription;
    }

    @Override
    public void setRebaseDescription(RebaseDescription rebaseDescription) {
        if (rebaseDescription == null) {
            throw new IllegalArgumentException();
        }
        this.rebaseDescription = rebaseDescription;
    }

    @Override
    public boolean hasRebaseDescription() {
        return !this.rebaseDescription.getValue().equals("");
    }
}

