/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.reactome;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.reactome.Reactome;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.reactome.ReactomeAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.reactome.ReactomeDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ReactomeImpl
extends DatabaseCrossReferenceImpl
implements Reactome,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.REACTOME;
    private long id = 0L;
    private ReactomeAccessionNumber reactomeAccessionNumber = DefaultXRefFactory.getInstance().buildReactomeAccessionNumber("");
    private ReactomeDescription reactomeDescription = DefaultXRefFactory.getInstance().buildReactomeDescription("");

    public ReactomeImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getReactomeAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ReactomeImpl(ReactomeImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasReactomeAccessionNumber()) {
            this.setReactomeAccessionNumber(toCopy.getReactomeAccessionNumber());
        }
        if (toCopy.hasReactomeDescription()) {
            this.setReactomeDescription(toCopy.getReactomeDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReactomeImpl)) {
            return false;
        }
        ReactomeImpl myClass = (ReactomeImpl)o;
        if (!this.reactomeAccessionNumber.equals(myClass.getReactomeAccessionNumber())) {
            return false;
        }
        return this.reactomeDescription.equals(myClass.getReactomeDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.reactomeAccessionNumber != null ? this.reactomeAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.reactomeDescription != null ? this.reactomeDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.reactomeAccessionNumber + ":" + this.reactomeDescription + ";";
    }

    @Override
    public ReactomeAccessionNumber getReactomeAccessionNumber() {
        return this.reactomeAccessionNumber;
    }

    @Override
    public void setReactomeAccessionNumber(ReactomeAccessionNumber reactomeAccessionNumber) {
        if (reactomeAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.reactomeAccessionNumber = reactomeAccessionNumber;
    }

    @Override
    public boolean hasReactomeAccessionNumber() {
        return !this.reactomeAccessionNumber.getValue().equals("");
    }

    @Override
    public ReactomeDescription getReactomeDescription() {
        return this.reactomeDescription;
    }

    @Override
    public void setReactomeDescription(ReactomeDescription reactomeDescription) {
        if (reactomeDescription == null) {
            throw new IllegalArgumentException();
        }
        this.reactomeDescription = reactomeDescription;
    }

    @Override
    public boolean hasReactomeDescription() {
        return !this.reactomeDescription.getValue().equals("");
    }
}

