/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pseudocap;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pseudocap.PseudoCAP;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pseudocap.PseudoCAPAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pseudocap.PseudoCAPDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PseudoCAPImpl
extends DatabaseCrossReferenceImpl
implements PseudoCAP,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PSEUDOCAP;
    private long id = 0L;
    private PseudoCAPAccessionNumber pseudoCAPAccessionNumber = DefaultXRefFactory.getInstance().buildPseudoCAPAccessionNumber("");
    private PseudoCAPDescription pseudoCAPDescription = DefaultXRefFactory.getInstance().buildPseudoCAPDescription("");

    public PseudoCAPImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPseudoCAPAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PseudoCAPImpl(PseudoCAPImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPseudoCAPAccessionNumber()) {
            this.setPseudoCAPAccessionNumber(toCopy.getPseudoCAPAccessionNumber());
        }
        if (toCopy.hasPseudoCAPDescription()) {
            this.setPseudoCAPDescription(toCopy.getPseudoCAPDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PseudoCAPImpl)) {
            return false;
        }
        PseudoCAPImpl myClass = (PseudoCAPImpl)o;
        if (!this.pseudoCAPAccessionNumber.equals(myClass.getPseudoCAPAccessionNumber())) {
            return false;
        }
        return this.pseudoCAPDescription.equals(myClass.getPseudoCAPDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pseudoCAPAccessionNumber != null ? this.pseudoCAPAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pseudoCAPDescription != null ? this.pseudoCAPDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pseudoCAPAccessionNumber + ":" + this.pseudoCAPDescription + ";";
    }

    @Override
    public PseudoCAPAccessionNumber getPseudoCAPAccessionNumber() {
        return this.pseudoCAPAccessionNumber;
    }

    @Override
    public void setPseudoCAPAccessionNumber(PseudoCAPAccessionNumber pseudoCAPAccessionNumber) {
        if (pseudoCAPAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pseudoCAPAccessionNumber = pseudoCAPAccessionNumber;
    }

    @Override
    public boolean hasPseudoCAPAccessionNumber() {
        return !this.pseudoCAPAccessionNumber.getValue().equals("");
    }

    @Override
    public PseudoCAPDescription getPseudoCAPDescription() {
        return this.pseudoCAPDescription;
    }

    @Override
    public void setPseudoCAPDescription(PseudoCAPDescription pseudoCAPDescription) {
        if (pseudoCAPDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pseudoCAPDescription = pseudoCAPDescription;
    }

    @Override
    public boolean hasPseudoCAPDescription() {
        return !this.pseudoCAPDescription.getValue().equals("");
    }
}

