/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.protclustdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.protclustdb.ProtClustDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.protclustdb.ProtClustDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.protclustdb.ProtClustDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ProtClustDBImpl
extends DatabaseCrossReferenceImpl
implements ProtClustDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PROTCLUSTDB;
    private long id = 0L;
    private ProtClustDBAccessionNumber protClustDBAccessionNumber = DefaultXRefFactory.getInstance().buildProtClustDBAccessionNumber("");
    private ProtClustDBDescription protClustDBDescription = DefaultXRefFactory.getInstance().buildProtClustDBDescription("");

    public ProtClustDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getProtClustDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ProtClustDBImpl(ProtClustDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasProtClustDBAccessionNumber()) {
            this.setProtClustDBAccessionNumber(toCopy.getProtClustDBAccessionNumber());
        }
        if (toCopy.hasProtClustDBDescription()) {
            this.setProtClustDBDescription(toCopy.getProtClustDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtClustDBImpl)) {
            return false;
        }
        ProtClustDBImpl myClass = (ProtClustDBImpl)o;
        if (!this.protClustDBAccessionNumber.equals(myClass.getProtClustDBAccessionNumber())) {
            return false;
        }
        return this.protClustDBDescription.equals(myClass.getProtClustDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.protClustDBAccessionNumber != null ? this.protClustDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.protClustDBDescription != null ? this.protClustDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.protClustDBAccessionNumber + ":" + this.protClustDBDescription + ";";
    }

    @Override
    public ProtClustDBAccessionNumber getProtClustDBAccessionNumber() {
        return this.protClustDBAccessionNumber;
    }

    @Override
    public void setProtClustDBAccessionNumber(ProtClustDBAccessionNumber protClustDBAccessionNumber) {
        if (protClustDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.protClustDBAccessionNumber = protClustDBAccessionNumber;
    }

    @Override
    public boolean hasProtClustDBAccessionNumber() {
        return !this.protClustDBAccessionNumber.getValue().equals("");
    }

    @Override
    public ProtClustDBDescription getProtClustDBDescription() {
        return this.protClustDBDescription;
    }

    @Override
    public void setProtClustDBDescription(ProtClustDBDescription protClustDBDescription) {
        if (protClustDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.protClustDBDescription = protClustDBDescription;
    }

    @Override
    public boolean hasProtClustDBDescription() {
        return !this.protClustDBDescription.getValue().equals("");
    }
}

