/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.prosite;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prosite.Prosite;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prosite.PrositeAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prosite.PrositeDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prosite.PrositeDescriptionOther;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PrositeImpl
extends DatabaseCrossReferenceImpl
implements Prosite,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PROSITE;
    private long id = 0L;
    private PrositeAccessionNumber prositeAccessionNumber = DefaultXRefFactory.getInstance().buildPrositeAccessionNumber("");
    private PrositeDescription prositeDescription = DefaultXRefFactory.getInstance().buildPrositeDescription("");
    private PrositeDescriptionOther prositeDescriptionOther = DefaultXRefFactory.getInstance().buildPrositeDescriptionOther("");

    public PrositeImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPrositeAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PrositeImpl(PrositeImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPrositeAccessionNumber()) {
            this.setPrositeAccessionNumber(toCopy.getPrositeAccessionNumber());
        }
        if (toCopy.hasPrositeDescription()) {
            this.setPrositeDescription(toCopy.getPrositeDescription());
        }
        if (toCopy.hasPrositeDescriptionOther()) {
            this.setPrositeDescriptionOther(toCopy.getPrositeDescriptionOther());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrositeImpl)) {
            return false;
        }
        PrositeImpl myClass = (PrositeImpl)o;
        if (!this.prositeAccessionNumber.equals(myClass.getPrositeAccessionNumber())) {
            return false;
        }
        if (!this.prositeDescription.equals(myClass.getPrositeDescription())) {
            return false;
        }
        return this.prositeDescriptionOther.equals(myClass.getPrositeDescriptionOther());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.prositeAccessionNumber != null ? this.prositeAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.prositeDescription != null ? this.prositeDescription.hashCode() : 0);
        result = 29 * result + (this.prositeDescriptionOther != null ? this.prositeDescriptionOther.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.prositeAccessionNumber + ":" + this.prositeDescription + ":" + this.prositeDescriptionOther + ";";
    }

    @Override
    public PrositeAccessionNumber getPrositeAccessionNumber() {
        return this.prositeAccessionNumber;
    }

    @Override
    public void setPrositeAccessionNumber(PrositeAccessionNumber prositeAccessionNumber) {
        if (prositeAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.prositeAccessionNumber = prositeAccessionNumber;
    }

    @Override
    public boolean hasPrositeAccessionNumber() {
        return !this.prositeAccessionNumber.getValue().equals("");
    }

    @Override
    public PrositeDescription getPrositeDescription() {
        return this.prositeDescription;
    }

    @Override
    public void setPrositeDescription(PrositeDescription prositeDescription) {
        if (prositeDescription == null) {
            throw new IllegalArgumentException();
        }
        this.prositeDescription = prositeDescription;
    }

    @Override
    public boolean hasPrositeDescription() {
        return !this.prositeDescription.getValue().equals("");
    }

    @Override
    public PrositeDescriptionOther getPrositeDescriptionOther() {
        return this.prositeDescriptionOther;
    }

    @Override
    public void setPrositeDescriptionOther(PrositeDescriptionOther prositeDescriptionOther) {
        if (prositeDescriptionOther == null) {
            throw new IllegalArgumentException();
        }
        this.prositeDescriptionOther = prositeDescriptionOther;
    }

    @Override
    public boolean hasPrositeDescriptionOther() {
        return !this.prositeDescriptionOther.getValue().equals("");
    }
}

