/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.promex;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.promex.ProMEX;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.promex.ProMEXAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.promex.ProMEXDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ProMEXImpl
extends DatabaseCrossReferenceImpl
implements ProMEX,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PROMEX;
    private long id = 0L;
    private ProMEXAccessionNumber proMEXAccessionNumber = DefaultXRefFactory.getInstance().buildProMEXAccessionNumber("");
    private ProMEXDescription proMEXDescription = DefaultXRefFactory.getInstance().buildProMEXDescription("");

    public ProMEXImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getProMEXAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ProMEXImpl(ProMEXImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasProMEXAccessionNumber()) {
            this.setProMEXAccessionNumber(toCopy.getProMEXAccessionNumber());
        }
        if (toCopy.hasProMEXDescription()) {
            this.setProMEXDescription(toCopy.getProMEXDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProMEXImpl)) {
            return false;
        }
        ProMEXImpl myClass = (ProMEXImpl)o;
        if (!this.proMEXAccessionNumber.equals(myClass.getProMEXAccessionNumber())) {
            return false;
        }
        return this.proMEXDescription.equals(myClass.getProMEXDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.proMEXAccessionNumber != null ? this.proMEXAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.proMEXDescription != null ? this.proMEXDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.proMEXAccessionNumber + ":" + this.proMEXDescription + ";";
    }

    @Override
    public ProMEXAccessionNumber getProMEXAccessionNumber() {
        return this.proMEXAccessionNumber;
    }

    @Override
    public void setProMEXAccessionNumber(ProMEXAccessionNumber proMEXAccessionNumber) {
        if (proMEXAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.proMEXAccessionNumber = proMEXAccessionNumber;
    }

    @Override
    public boolean hasProMEXAccessionNumber() {
        return !this.proMEXAccessionNumber.getValue().equals("");
    }

    @Override
    public ProMEXDescription getProMEXDescription() {
        return this.proMEXDescription;
    }

    @Override
    public void setProMEXDescription(ProMEXDescription proMEXDescription) {
        if (proMEXDescription == null) {
            throw new IllegalArgumentException();
        }
        this.proMEXDescription = proMEXDescription;
    }

    @Override
    public boolean hasProMEXDescription() {
        return !this.proMEXDescription.getValue().equals("");
    }
}

