/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.prodom;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prodom.ProDom;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prodom.ProDomAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prodom.ProDomDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prodom.ProDomHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ProDomImpl
extends DatabaseCrossReferenceImpl
implements ProDom,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PRODOM;
    private long id = 0L;
    private ProDomAccessionNumber proDomAccessionNumber = DefaultXRefFactory.getInstance().buildProDomAccessionNumber("");
    private ProDomDescription proDomDescription = DefaultXRefFactory.getInstance().buildProDomDescription("");
    private ProDomHitNumber proDomHitNumber = DefaultXRefFactory.getInstance().buildProDomHitNumber("");

    public ProDomImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getProDomAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ProDomImpl(ProDomImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasProDomAccessionNumber()) {
            this.setProDomAccessionNumber(toCopy.getProDomAccessionNumber());
        }
        if (toCopy.hasProDomDescription()) {
            this.setProDomDescription(toCopy.getProDomDescription());
        }
        if (toCopy.hasProDomHitNumber()) {
            this.setProDomHitNumber(toCopy.getProDomHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProDomImpl)) {
            return false;
        }
        ProDomImpl myClass = (ProDomImpl)o;
        if (!this.proDomAccessionNumber.equals(myClass.getProDomAccessionNumber())) {
            return false;
        }
        if (!this.proDomDescription.equals(myClass.getProDomDescription())) {
            return false;
        }
        return this.proDomHitNumber.equals(myClass.getProDomHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.proDomAccessionNumber != null ? this.proDomAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.proDomDescription != null ? this.proDomDescription.hashCode() : 0);
        result = 29 * result + (this.proDomHitNumber != null ? this.proDomHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.proDomAccessionNumber + ":" + this.proDomDescription + ":" + this.proDomHitNumber + ";";
    }

    @Override
    public ProDomAccessionNumber getProDomAccessionNumber() {
        return this.proDomAccessionNumber;
    }

    @Override
    public void setProDomAccessionNumber(ProDomAccessionNumber proDomAccessionNumber) {
        if (proDomAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.proDomAccessionNumber = proDomAccessionNumber;
    }

    @Override
    public boolean hasProDomAccessionNumber() {
        return !this.proDomAccessionNumber.getValue().equals("");
    }

    @Override
    public ProDomDescription getProDomDescription() {
        return this.proDomDescription;
    }

    @Override
    public void setProDomDescription(ProDomDescription proDomDescription) {
        if (proDomDescription == null) {
            throw new IllegalArgumentException();
        }
        this.proDomDescription = proDomDescription;
    }

    @Override
    public boolean hasProDomDescription() {
        return !this.proDomDescription.getValue().equals("");
    }

    @Override
    public ProDomHitNumber getProDomHitNumber() {
        return this.proDomHitNumber;
    }

    @Override
    public void setProDomHitNumber(ProDomHitNumber proDomHitNumber) {
        if (proDomHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.proDomHitNumber = proDomHitNumber;
    }

    @Override
    public boolean hasProDomHitNumber() {
        return !this.proDomHitNumber.getValue().equals("");
    }
}

