/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.prints;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prints.Prints;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prints.PrintsAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.prints.PrintsDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PrintsImpl
extends DatabaseCrossReferenceImpl
implements Prints,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PRINTS;
    private long id = 0L;
    private PrintsAccessionNumber printsAccessionNumber = DefaultXRefFactory.getInstance().buildPrintsAccessionNumber("");
    private PrintsDescription printsDescription = DefaultXRefFactory.getInstance().buildPrintsDescription("");

    public PrintsImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPrintsAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PrintsImpl(PrintsImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPrintsAccessionNumber()) {
            this.setPrintsAccessionNumber(toCopy.getPrintsAccessionNumber());
        }
        if (toCopy.hasPrintsDescription()) {
            this.setPrintsDescription(toCopy.getPrintsDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrintsImpl)) {
            return false;
        }
        PrintsImpl myClass = (PrintsImpl)o;
        if (!this.printsAccessionNumber.equals(myClass.getPrintsAccessionNumber())) {
            return false;
        }
        return this.printsDescription.equals(myClass.getPrintsDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.printsAccessionNumber != null ? this.printsAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.printsDescription != null ? this.printsDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.printsAccessionNumber + ":" + this.printsDescription + ";";
    }

    @Override
    public PrintsAccessionNumber getPrintsAccessionNumber() {
        return this.printsAccessionNumber;
    }

    @Override
    public void setPrintsAccessionNumber(PrintsAccessionNumber printsAccessionNumber) {
        if (printsAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.printsAccessionNumber = printsAccessionNumber;
    }

    @Override
    public boolean hasPrintsAccessionNumber() {
        return !this.printsAccessionNumber.getValue().equals("");
    }

    @Override
    public PrintsDescription getPrintsDescription() {
        return this.printsDescription;
    }

    @Override
    public void setPrintsDescription(PrintsDescription printsDescription) {
        if (printsDescription == null) {
            throw new IllegalArgumentException();
        }
        this.printsDescription = printsDescription;
    }

    @Override
    public boolean hasPrintsDescription() {
        return !this.printsDescription.getValue().equals("");
    }
}

