/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pride;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pride.Pride;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pride.PrideAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pride.PrideDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PrideImpl
extends DatabaseCrossReferenceImpl
implements Pride,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PRIDE;
    private long id = 0L;
    private PrideAccessionNumber prideAccessionNumber = DefaultXRefFactory.getInstance().buildPrideAccessionNumber("");
    private PrideDescription prideDescription = DefaultXRefFactory.getInstance().buildPrideDescription("");

    public PrideImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPrideAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PrideImpl(PrideImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPrideAccessionNumber()) {
            this.setPrideAccessionNumber(toCopy.getPrideAccessionNumber());
        }
        if (toCopy.hasPrideDescription()) {
            this.setPrideDescription(toCopy.getPrideDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrideImpl)) {
            return false;
        }
        PrideImpl myClass = (PrideImpl)o;
        if (!this.prideAccessionNumber.equals(myClass.getPrideAccessionNumber())) {
            return false;
        }
        return this.prideDescription.equals(myClass.getPrideDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.prideAccessionNumber != null ? this.prideAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.prideDescription != null ? this.prideDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.prideAccessionNumber + ":" + this.prideDescription + ";";
    }

    @Override
    public PrideAccessionNumber getPrideAccessionNumber() {
        return this.prideAccessionNumber;
    }

    @Override
    public void setPrideAccessionNumber(PrideAccessionNumber prideAccessionNumber) {
        if (prideAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.prideAccessionNumber = prideAccessionNumber;
    }

    @Override
    public boolean hasPrideAccessionNumber() {
        return !this.prideAccessionNumber.getValue().equals("");
    }

    @Override
    public PrideDescription getPrideDescription() {
        return this.prideDescription;
    }

    @Override
    public void setPrideDescription(PrideDescription prideDescription) {
        if (prideDescription == null) {
            throw new IllegalArgumentException();
        }
        this.prideDescription = prideDescription;
    }

    @Override
    public boolean hasPrideDescription() {
        return !this.prideDescription.getValue().equals("");
    }
}

