/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pptasedb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pptasedb.PptaseDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pptasedb.PptaseDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pptasedb.PptaseDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PptaseDBImpl
extends DatabaseCrossReferenceImpl
implements PptaseDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PPTASEDB;
    private long id = 0L;
    private PptaseDBAccessionNumber pptaseDBAccessionNumber = DefaultXRefFactory.getInstance().buildPptaseDBAccessionNumber("");
    private PptaseDBDescription pptaseDBDescription = DefaultXRefFactory.getInstance().buildPptaseDBDescription("");

    public PptaseDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPptaseDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PptaseDBImpl(PptaseDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPptaseDBAccessionNumber()) {
            this.setPptaseDBAccessionNumber(toCopy.getPptaseDBAccessionNumber());
        }
        if (toCopy.hasPptaseDBDescription()) {
            this.setPptaseDBDescription(toCopy.getPptaseDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PptaseDBImpl)) {
            return false;
        }
        PptaseDBImpl myClass = (PptaseDBImpl)o;
        if (!this.pptaseDBAccessionNumber.equals(myClass.getPptaseDBAccessionNumber())) {
            return false;
        }
        return this.pptaseDBDescription.equals(myClass.getPptaseDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pptaseDBAccessionNumber != null ? this.pptaseDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pptaseDBDescription != null ? this.pptaseDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pptaseDBAccessionNumber + ":" + this.pptaseDBDescription + ";";
    }

    @Override
    public PptaseDBAccessionNumber getPptaseDBAccessionNumber() {
        return this.pptaseDBAccessionNumber;
    }

    @Override
    public void setPptaseDBAccessionNumber(PptaseDBAccessionNumber pptaseDBAccessionNumber) {
        if (pptaseDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pptaseDBAccessionNumber = pptaseDBAccessionNumber;
    }

    @Override
    public boolean hasPptaseDBAccessionNumber() {
        return !this.pptaseDBAccessionNumber.getValue().equals("");
    }

    @Override
    public PptaseDBDescription getPptaseDBDescription() {
        return this.pptaseDBDescription;
    }

    @Override
    public void setPptaseDBDescription(PptaseDBDescription pptaseDBDescription) {
        if (pptaseDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pptaseDBDescription = pptaseDBDescription;
    }

    @Override
    public boolean hasPptaseDBDescription() {
        return !this.pptaseDBDescription.getValue().equals("");
    }
}

