/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pmapcutdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pmapcutdb.PMAPCutDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pmapcutdb.PMAPCutDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pmapcutdb.PMAPCutDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PMAPCutDBImpl
extends DatabaseCrossReferenceImpl
implements PMAPCutDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PMAPCUTDB;
    private long id = 0L;
    private PMAPCutDBAccessionNumber pMAPCutDBAccessionNumber = DefaultXRefFactory.getInstance().buildPMAPCutDBAccessionNumber("");
    private PMAPCutDBDescription pMAPCutDBDescription = DefaultXRefFactory.getInstance().buildPMAPCutDBDescription("");

    public PMAPCutDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPMAPCutDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PMAPCutDBImpl(PMAPCutDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPMAPCutDBAccessionNumber()) {
            this.setPMAPCutDBAccessionNumber(toCopy.getPMAPCutDBAccessionNumber());
        }
        if (toCopy.hasPMAPCutDBDescription()) {
            this.setPMAPCutDBDescription(toCopy.getPMAPCutDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PMAPCutDBImpl)) {
            return false;
        }
        PMAPCutDBImpl myClass = (PMAPCutDBImpl)o;
        if (!this.pMAPCutDBAccessionNumber.equals(myClass.getPMAPCutDBAccessionNumber())) {
            return false;
        }
        return this.pMAPCutDBDescription.equals(myClass.getPMAPCutDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pMAPCutDBAccessionNumber != null ? this.pMAPCutDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pMAPCutDBDescription != null ? this.pMAPCutDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pMAPCutDBAccessionNumber + ":" + this.pMAPCutDBDescription + ";";
    }

    @Override
    public PMAPCutDBAccessionNumber getPMAPCutDBAccessionNumber() {
        return this.pMAPCutDBAccessionNumber;
    }

    @Override
    public void setPMAPCutDBAccessionNumber(PMAPCutDBAccessionNumber pMAPCutDBAccessionNumber) {
        if (pMAPCutDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pMAPCutDBAccessionNumber = pMAPCutDBAccessionNumber;
    }

    @Override
    public boolean hasPMAPCutDBAccessionNumber() {
        return !this.pMAPCutDBAccessionNumber.getValue().equals("");
    }

    @Override
    public PMAPCutDBDescription getPMAPCutDBDescription() {
        return this.pMAPCutDBDescription;
    }

    @Override
    public void setPMAPCutDBDescription(PMAPCutDBDescription pMAPCutDBDescription) {
        if (pMAPCutDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pMAPCutDBDescription = pMAPCutDBDescription;
    }

    @Override
    public boolean hasPMAPCutDBDescription() {
        return !this.pMAPCutDBDescription.getValue().equals("");
    }
}

