/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pirsf;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pirsf.Pirsf;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pirsf.PirsfAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pirsf.PirsfDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pirsf.PirsfHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PirsfImpl
extends DatabaseCrossReferenceImpl
implements Pirsf,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PIRSF;
    private long id = 0L;
    private PirsfAccessionNumber pirsfAccessionNumber = DefaultXRefFactory.getInstance().buildPirsfAccessionNumber("");
    private PirsfDescription pirsfDescription = DefaultXRefFactory.getInstance().buildPirsfDescription("");
    private PirsfHitNumber pirsfHitNumber = DefaultXRefFactory.getInstance().buildPirsfHitNumber("");

    public PirsfImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPirsfAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PirsfImpl(PirsfImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPirsfAccessionNumber()) {
            this.setPirsfAccessionNumber(toCopy.getPirsfAccessionNumber());
        }
        if (toCopy.hasPirsfDescription()) {
            this.setPirsfDescription(toCopy.getPirsfDescription());
        }
        if (toCopy.hasPirsfHitNumber()) {
            this.setPirsfHitNumber(toCopy.getPirsfHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PirsfImpl)) {
            return false;
        }
        PirsfImpl myClass = (PirsfImpl)o;
        if (!this.pirsfAccessionNumber.equals(myClass.getPirsfAccessionNumber())) {
            return false;
        }
        if (!this.pirsfDescription.equals(myClass.getPirsfDescription())) {
            return false;
        }
        return this.pirsfHitNumber.equals(myClass.getPirsfHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pirsfAccessionNumber != null ? this.pirsfAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pirsfDescription != null ? this.pirsfDescription.hashCode() : 0);
        result = 29 * result + (this.pirsfHitNumber != null ? this.pirsfHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pirsfAccessionNumber + ":" + this.pirsfDescription + ":" + this.pirsfHitNumber + ";";
    }

    @Override
    public PirsfAccessionNumber getPirsfAccessionNumber() {
        return this.pirsfAccessionNumber;
    }

    @Override
    public void setPirsfAccessionNumber(PirsfAccessionNumber pirsfAccessionNumber) {
        if (pirsfAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pirsfAccessionNumber = pirsfAccessionNumber;
    }

    @Override
    public boolean hasPirsfAccessionNumber() {
        return !this.pirsfAccessionNumber.getValue().equals("");
    }

    @Override
    public PirsfDescription getPirsfDescription() {
        return this.pirsfDescription;
    }

    @Override
    public void setPirsfDescription(PirsfDescription pirsfDescription) {
        if (pirsfDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pirsfDescription = pirsfDescription;
    }

    @Override
    public boolean hasPirsfDescription() {
        return !this.pirsfDescription.getValue().equals("");
    }

    @Override
    public PirsfHitNumber getPirsfHitNumber() {
        return this.pirsfHitNumber;
    }

    @Override
    public void setPirsfHitNumber(PirsfHitNumber pirsfHitNumber) {
        if (pirsfHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pirsfHitNumber = pirsfHitNumber;
    }

    @Override
    public boolean hasPirsfHitNumber() {
        return !this.pirsfHitNumber.getValue().equals("");
    }
}

