/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pir;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pir.Pir;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pir.PirAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pir.PirDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PirImpl
extends DatabaseCrossReferenceImpl
implements Pir,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PIR;
    private long id = 0L;
    private PirAccessionNumber pirAccessionNumber = DefaultXRefFactory.getInstance().buildPirAccessionNumber("");
    private PirDescription pirDescription = DefaultXRefFactory.getInstance().buildPirDescription("");

    public PirImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPirAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PirImpl(PirImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPirAccessionNumber()) {
            this.setPirAccessionNumber(toCopy.getPirAccessionNumber());
        }
        if (toCopy.hasPirDescription()) {
            this.setPirDescription(toCopy.getPirDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PirImpl)) {
            return false;
        }
        PirImpl myClass = (PirImpl)o;
        if (!this.pirAccessionNumber.equals(myClass.getPirAccessionNumber())) {
            return false;
        }
        return this.pirDescription.equals(myClass.getPirDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pirAccessionNumber != null ? this.pirAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pirDescription != null ? this.pirDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pirAccessionNumber + ":" + this.pirDescription + ";";
    }

    @Override
    public PirAccessionNumber getPirAccessionNumber() {
        return this.pirAccessionNumber;
    }

    @Override
    public void setPirAccessionNumber(PirAccessionNumber pirAccessionNumber) {
        if (pirAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pirAccessionNumber = pirAccessionNumber;
    }

    @Override
    public boolean hasPirAccessionNumber() {
        return !this.pirAccessionNumber.getValue().equals("");
    }

    @Override
    public PirDescription getPirDescription() {
        return this.pirDescription;
    }

    @Override
    public void setPirDescription(PirDescription pirDescription) {
        if (pirDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pirDescription = pirDescription;
    }

    @Override
    public boolean hasPirDescription() {
        return !this.pirDescription.getValue().equals("");
    }
}

