/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.phylomedb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phylomedb.PhylomeDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phylomedb.PhylomeDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phylomedb.PhylomeDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PhylomeDBImpl
extends DatabaseCrossReferenceImpl
implements PhylomeDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PHYLOMEDB;
    private long id = 0L;
    private PhylomeDBAccessionNumber phylomeDBAccessionNumber = DefaultXRefFactory.getInstance().buildPhylomeDBAccessionNumber("");
    private PhylomeDBDescription phylomeDBDescription = DefaultXRefFactory.getInstance().buildPhylomeDBDescription("");

    public PhylomeDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPhylomeDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PhylomeDBImpl(PhylomeDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPhylomeDBAccessionNumber()) {
            this.setPhylomeDBAccessionNumber(toCopy.getPhylomeDBAccessionNumber());
        }
        if (toCopy.hasPhylomeDBDescription()) {
            this.setPhylomeDBDescription(toCopy.getPhylomeDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhylomeDBImpl)) {
            return false;
        }
        PhylomeDBImpl myClass = (PhylomeDBImpl)o;
        if (!this.phylomeDBAccessionNumber.equals(myClass.getPhylomeDBAccessionNumber())) {
            return false;
        }
        return this.phylomeDBDescription.equals(myClass.getPhylomeDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.phylomeDBAccessionNumber != null ? this.phylomeDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.phylomeDBDescription != null ? this.phylomeDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.phylomeDBAccessionNumber + ":" + this.phylomeDBDescription + ";";
    }

    @Override
    public PhylomeDBAccessionNumber getPhylomeDBAccessionNumber() {
        return this.phylomeDBAccessionNumber;
    }

    @Override
    public void setPhylomeDBAccessionNumber(PhylomeDBAccessionNumber phylomeDBAccessionNumber) {
        if (phylomeDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.phylomeDBAccessionNumber = phylomeDBAccessionNumber;
    }

    @Override
    public boolean hasPhylomeDBAccessionNumber() {
        return !this.phylomeDBAccessionNumber.getValue().equals("");
    }

    @Override
    public PhylomeDBDescription getPhylomeDBDescription() {
        return this.phylomeDBDescription;
    }

    @Override
    public void setPhylomeDBDescription(PhylomeDBDescription phylomeDBDescription) {
        if (phylomeDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.phylomeDBDescription = phylomeDBDescription;
    }

    @Override
    public boolean hasPhylomeDBDescription() {
        return !this.phylomeDBDescription.getValue().equals("");
    }
}

