/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.photolist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.photolist.PhotoList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.photolist.PhotoListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.photolist.PhotoListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PhotoListImpl
extends DatabaseCrossReferenceImpl
implements PhotoList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PHOTOLIST;
    private long id = 0L;
    private PhotoListAccessionNumber photoListAccessionNumber = DefaultXRefFactory.getInstance().buildPhotoListAccessionNumber("");
    private PhotoListDescription photoListDescription = DefaultXRefFactory.getInstance().buildPhotoListDescription("");

    public PhotoListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPhotoListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PhotoListImpl(PhotoListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPhotoListAccessionNumber()) {
            this.setPhotoListAccessionNumber(toCopy.getPhotoListAccessionNumber());
        }
        if (toCopy.hasPhotoListDescription()) {
            this.setPhotoListDescription(toCopy.getPhotoListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhotoListImpl)) {
            return false;
        }
        PhotoListImpl myClass = (PhotoListImpl)o;
        if (!this.photoListAccessionNumber.equals(myClass.getPhotoListAccessionNumber())) {
            return false;
        }
        return this.photoListDescription.equals(myClass.getPhotoListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.photoListAccessionNumber != null ? this.photoListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.photoListDescription != null ? this.photoListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.photoListAccessionNumber + ":" + this.photoListDescription + ";";
    }

    @Override
    public PhotoListAccessionNumber getPhotoListAccessionNumber() {
        return this.photoListAccessionNumber;
    }

    @Override
    public void setPhotoListAccessionNumber(PhotoListAccessionNumber photoListAccessionNumber) {
        if (photoListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.photoListAccessionNumber = photoListAccessionNumber;
    }

    @Override
    public boolean hasPhotoListAccessionNumber() {
        return !this.photoListAccessionNumber.getValue().equals("");
    }

    @Override
    public PhotoListDescription getPhotoListDescription() {
        return this.photoListDescription;
    }

    @Override
    public void setPhotoListDescription(PhotoListDescription photoListDescription) {
        if (photoListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.photoListDescription = photoListDescription;
    }

    @Override
    public boolean hasPhotoListDescription() {
        return !this.photoListDescription.getValue().equals("");
    }
}

