/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.phossite;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phossite.PhosSite;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phossite.PhosSiteAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phossite.PhosSiteDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PhosSiteImpl
extends DatabaseCrossReferenceImpl
implements PhosSite,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PHOSSITE;
    private long id = 0L;
    private PhosSiteAccessionNumber phosSiteAccessionNumber = DefaultXRefFactory.getInstance().buildPhosSiteAccessionNumber("");
    private PhosSiteDescription phosSiteDescription = DefaultXRefFactory.getInstance().buildPhosSiteDescription("");

    public PhosSiteImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPhosSiteAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PhosSiteImpl(PhosSiteImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPhosSiteAccessionNumber()) {
            this.setPhosSiteAccessionNumber(toCopy.getPhosSiteAccessionNumber());
        }
        if (toCopy.hasPhosSiteDescription()) {
            this.setPhosSiteDescription(toCopy.getPhosSiteDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhosSiteImpl)) {
            return false;
        }
        PhosSiteImpl myClass = (PhosSiteImpl)o;
        if (!this.phosSiteAccessionNumber.equals(myClass.getPhosSiteAccessionNumber())) {
            return false;
        }
        return this.phosSiteDescription.equals(myClass.getPhosSiteDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.phosSiteAccessionNumber != null ? this.phosSiteAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.phosSiteDescription != null ? this.phosSiteDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.phosSiteAccessionNumber + ":" + this.phosSiteDescription + ";";
    }

    @Override
    public PhosSiteAccessionNumber getPhosSiteAccessionNumber() {
        return this.phosSiteAccessionNumber;
    }

    @Override
    public void setPhosSiteAccessionNumber(PhosSiteAccessionNumber phosSiteAccessionNumber) {
        if (phosSiteAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.phosSiteAccessionNumber = phosSiteAccessionNumber;
    }

    @Override
    public boolean hasPhosSiteAccessionNumber() {
        return !this.phosSiteAccessionNumber.getValue().equals("");
    }

    @Override
    public PhosSiteDescription getPhosSiteDescription() {
        return this.phosSiteDescription;
    }

    @Override
    public void setPhosSiteDescription(PhosSiteDescription phosSiteDescription) {
        if (phosSiteDescription == null) {
            throw new IllegalArgumentException();
        }
        this.phosSiteDescription = phosSiteDescription;
    }

    @Override
    public boolean hasPhosSiteDescription() {
        return !this.phosSiteDescription.getValue().equals("");
    }
}

