/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.phosphosite;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phosphosite.PhosphoSite;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phosphosite.PhosphoSiteAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.phosphosite.PhosphoSiteDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PhosphoSiteImpl
extends DatabaseCrossReferenceImpl
implements PhosphoSite,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PHOSPHOSITE;
    private long id = 0L;
    private PhosphoSiteAccessionNumber phosphoSiteAccessionNumber = DefaultXRefFactory.getInstance().buildPhosphoSiteAccessionNumber("");
    private PhosphoSiteDescription phosphoSiteDescription = DefaultXRefFactory.getInstance().buildPhosphoSiteDescription("");

    public PhosphoSiteImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPhosphoSiteAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PhosphoSiteImpl(PhosphoSiteImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPhosphoSiteAccessionNumber()) {
            this.setPhosphoSiteAccessionNumber(toCopy.getPhosphoSiteAccessionNumber());
        }
        if (toCopy.hasPhosphoSiteDescription()) {
            this.setPhosphoSiteDescription(toCopy.getPhosphoSiteDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhosphoSiteImpl)) {
            return false;
        }
        PhosphoSiteImpl myClass = (PhosphoSiteImpl)o;
        if (!this.phosphoSiteAccessionNumber.equals(myClass.getPhosphoSiteAccessionNumber())) {
            return false;
        }
        return this.phosphoSiteDescription.equals(myClass.getPhosphoSiteDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.phosphoSiteAccessionNumber != null ? this.phosphoSiteAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.phosphoSiteDescription != null ? this.phosphoSiteDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.phosphoSiteAccessionNumber + ":" + this.phosphoSiteDescription + ";";
    }

    @Override
    public PhosphoSiteAccessionNumber getPhosphoSiteAccessionNumber() {
        return this.phosphoSiteAccessionNumber;
    }

    @Override
    public void setPhosphoSiteAccessionNumber(PhosphoSiteAccessionNumber phosphoSiteAccessionNumber) {
        if (phosphoSiteAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.phosphoSiteAccessionNumber = phosphoSiteAccessionNumber;
    }

    @Override
    public boolean hasPhosphoSiteAccessionNumber() {
        return !this.phosphoSiteAccessionNumber.getValue().equals("");
    }

    @Override
    public PhosphoSiteDescription getPhosphoSiteDescription() {
        return this.phosphoSiteDescription;
    }

    @Override
    public void setPhosphoSiteDescription(PhosphoSiteDescription phosphoSiteDescription) {
        if (phosphoSiteDescription == null) {
            throw new IllegalArgumentException();
        }
        this.phosphoSiteDescription = phosphoSiteDescription;
    }

    @Override
    public boolean hasPhosphoSiteDescription() {
        return !this.phosphoSiteDescription.getValue().equals("");
    }
}

