/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pharmgkb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pharmgkb.PharmGKB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pharmgkb.PharmGKBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pharmgkb.PharmGKBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PharmGKBImpl
extends DatabaseCrossReferenceImpl
implements PharmGKB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PHARMGKB;
    private long id = 0L;
    private PharmGKBAccessionNumber pharmGKBAccessionNumber = DefaultXRefFactory.getInstance().buildPharmGKBAccessionNumber("");
    private PharmGKBDescription pharmGKBDescription = DefaultXRefFactory.getInstance().buildPharmGKBDescription("");

    public PharmGKBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPharmGKBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PharmGKBImpl(PharmGKBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPharmGKBAccessionNumber()) {
            this.setPharmGKBAccessionNumber(toCopy.getPharmGKBAccessionNumber());
        }
        if (toCopy.hasPharmGKBDescription()) {
            this.setPharmGKBDescription(toCopy.getPharmGKBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PharmGKBImpl)) {
            return false;
        }
        PharmGKBImpl myClass = (PharmGKBImpl)o;
        if (!this.pharmGKBAccessionNumber.equals(myClass.getPharmGKBAccessionNumber())) {
            return false;
        }
        return this.pharmGKBDescription.equals(myClass.getPharmGKBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pharmGKBAccessionNumber != null ? this.pharmGKBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pharmGKBDescription != null ? this.pharmGKBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pharmGKBAccessionNumber + ":" + this.pharmGKBDescription + ";";
    }

    @Override
    public PharmGKBAccessionNumber getPharmGKBAccessionNumber() {
        return this.pharmGKBAccessionNumber;
    }

    @Override
    public void setPharmGKBAccessionNumber(PharmGKBAccessionNumber pharmGKBAccessionNumber) {
        if (pharmGKBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pharmGKBAccessionNumber = pharmGKBAccessionNumber;
    }

    @Override
    public boolean hasPharmGKBAccessionNumber() {
        return !this.pharmGKBAccessionNumber.getValue().equals("");
    }

    @Override
    public PharmGKBDescription getPharmGKBDescription() {
        return this.pharmGKBDescription;
    }

    @Override
    public void setPharmGKBDescription(PharmGKBDescription pharmGKBDescription) {
        if (pharmGKBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pharmGKBDescription = pharmGKBDescription;
    }

    @Override
    public boolean hasPharmGKBDescription() {
        return !this.pharmGKBDescription.getValue().equals("");
    }
}

