/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pfam;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pfam.Pfam;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pfam.PfamAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pfam.PfamDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pfam.PfamHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PfamImpl
extends DatabaseCrossReferenceImpl
implements Pfam,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PFAM;
    private long id = 0L;
    private PfamAccessionNumber pfamAccessionNumber = DefaultXRefFactory.getInstance().buildPfamAccessionNumber("");
    private PfamDescription pfamDescription = DefaultXRefFactory.getInstance().buildPfamDescription("");
    private PfamHitNumber pfamHitNumber = DefaultXRefFactory.getInstance().buildPfamHitNumber("");

    public PfamImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPfamAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PfamImpl(PfamImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPfamAccessionNumber()) {
            this.setPfamAccessionNumber(toCopy.getPfamAccessionNumber());
        }
        if (toCopy.hasPfamDescription()) {
            this.setPfamDescription(toCopy.getPfamDescription());
        }
        if (toCopy.hasPfamHitNumber()) {
            this.setPfamHitNumber(toCopy.getPfamHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PfamImpl)) {
            return false;
        }
        PfamImpl myClass = (PfamImpl)o;
        if (!this.pfamAccessionNumber.equals(myClass.getPfamAccessionNumber())) {
            return false;
        }
        if (!this.pfamDescription.equals(myClass.getPfamDescription())) {
            return false;
        }
        return this.pfamHitNumber.equals(myClass.getPfamHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pfamAccessionNumber != null ? this.pfamAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pfamDescription != null ? this.pfamDescription.hashCode() : 0);
        result = 29 * result + (this.pfamHitNumber != null ? this.pfamHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pfamAccessionNumber + ":" + this.pfamDescription + ":" + this.pfamHitNumber + ";";
    }

    @Override
    public PfamAccessionNumber getPfamAccessionNumber() {
        return this.pfamAccessionNumber;
    }

    @Override
    public void setPfamAccessionNumber(PfamAccessionNumber pfamAccessionNumber) {
        if (pfamAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pfamAccessionNumber = pfamAccessionNumber;
    }

    @Override
    public boolean hasPfamAccessionNumber() {
        return !this.pfamAccessionNumber.getValue().equals("");
    }

    @Override
    public PfamDescription getPfamDescription() {
        return this.pfamDescription;
    }

    @Override
    public void setPfamDescription(PfamDescription pfamDescription) {
        if (pfamDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pfamDescription = pfamDescription;
    }

    @Override
    public boolean hasPfamDescription() {
        return !this.pfamDescription.getValue().equals("");
    }

    @Override
    public PfamHitNumber getPfamHitNumber() {
        return this.pfamHitNumber;
    }

    @Override
    public void setPfamHitNumber(PfamHitNumber pfamHitNumber) {
        if (pfamHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pfamHitNumber = pfamHitNumber;
    }

    @Override
    public boolean hasPfamHitNumber() {
        return !this.pfamHitNumber.getValue().equals("");
    }
}

