/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.peroxibase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.peroxibase.PeroxiBase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.peroxibase.PeroxiBaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.peroxibase.PeroxiBaseName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PeroxiBaseImpl
extends DatabaseCrossReferenceImpl
implements PeroxiBase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PEROXIBASE;
    private long id = 0L;
    private PeroxiBaseAccessionNumber peroxiBaseAccessionNumber = DefaultXRefFactory.getInstance().buildPeroxiBaseAccessionNumber("");
    private PeroxiBaseName peroxiBaseName = DefaultXRefFactory.getInstance().buildPeroxiBaseName("");

    public PeroxiBaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPeroxiBaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PeroxiBaseImpl(PeroxiBaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPeroxiBaseAccessionNumber()) {
            this.setPeroxiBaseAccessionNumber(toCopy.getPeroxiBaseAccessionNumber());
        }
        if (toCopy.hasPeroxiBaseName()) {
            this.setPeroxiBaseName(toCopy.getPeroxiBaseName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeroxiBaseImpl)) {
            return false;
        }
        PeroxiBaseImpl myClass = (PeroxiBaseImpl)o;
        if (!this.peroxiBaseAccessionNumber.equals(myClass.getPeroxiBaseAccessionNumber())) {
            return false;
        }
        return this.peroxiBaseName.equals(myClass.getPeroxiBaseName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.peroxiBaseAccessionNumber != null ? this.peroxiBaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.peroxiBaseName != null ? this.peroxiBaseName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.peroxiBaseAccessionNumber + ":" + this.peroxiBaseName + ";";
    }

    @Override
    public PeroxiBaseAccessionNumber getPeroxiBaseAccessionNumber() {
        return this.peroxiBaseAccessionNumber;
    }

    @Override
    public void setPeroxiBaseAccessionNumber(PeroxiBaseAccessionNumber peroxiBaseAccessionNumber) {
        if (peroxiBaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.peroxiBaseAccessionNumber = peroxiBaseAccessionNumber;
    }

    @Override
    public boolean hasPeroxiBaseAccessionNumber() {
        return !this.peroxiBaseAccessionNumber.getValue().equals("");
    }

    @Override
    public PeroxiBaseName getPeroxiBaseName() {
        return this.peroxiBaseName;
    }

    @Override
    public void setPeroxiBaseName(PeroxiBaseName peroxiBaseName) {
        if (peroxiBaseName == null) {
            throw new IllegalArgumentException();
        }
        this.peroxiBaseName = peroxiBaseName;
    }

    @Override
    public boolean hasPeroxiBaseName() {
        return !this.peroxiBaseName.getValue().equals("");
    }
}

