/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pdbsum;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdbsum.PDBsum;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdbsum.PDBsumAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdbsum.PDBsumDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PDBsumImpl
extends DatabaseCrossReferenceImpl
implements PDBsum,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PDBSUM;
    private long id = 0L;
    private PDBsumAccessionNumber pDBsumAccessionNumber = DefaultXRefFactory.getInstance().buildPDBsumAccessionNumber("");
    private PDBsumDescription pDBsumDescription = DefaultXRefFactory.getInstance().buildPDBsumDescription("");

    public PDBsumImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPDBsumAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PDBsumImpl(PDBsumImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPDBsumAccessionNumber()) {
            this.setPDBsumAccessionNumber(toCopy.getPDBsumAccessionNumber());
        }
        if (toCopy.hasPDBsumDescription()) {
            this.setPDBsumDescription(toCopy.getPDBsumDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PDBsumImpl)) {
            return false;
        }
        PDBsumImpl myClass = (PDBsumImpl)o;
        if (!this.pDBsumAccessionNumber.equals(myClass.getPDBsumAccessionNumber())) {
            return false;
        }
        return this.pDBsumDescription.equals(myClass.getPDBsumDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pDBsumAccessionNumber != null ? this.pDBsumAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pDBsumDescription != null ? this.pDBsumDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pDBsumAccessionNumber + ":" + this.pDBsumDescription + ";";
    }

    @Override
    public PDBsumAccessionNumber getPDBsumAccessionNumber() {
        return this.pDBsumAccessionNumber;
    }

    @Override
    public void setPDBsumAccessionNumber(PDBsumAccessionNumber pDBsumAccessionNumber) {
        if (pDBsumAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pDBsumAccessionNumber = pDBsumAccessionNumber;
    }

    @Override
    public boolean hasPDBsumAccessionNumber() {
        return !this.pDBsumAccessionNumber.getValue().equals("");
    }

    @Override
    public PDBsumDescription getPDBsumDescription() {
        return this.pDBsumDescription;
    }

    @Override
    public void setPDBsumDescription(PDBsumDescription pDBsumDescription) {
        if (pDBsumDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pDBsumDescription = pDBsumDescription;
    }

    @Override
    public boolean hasPDBsumDescription() {
        return !this.pDBsumDescription.getValue().equals("");
    }
}

