/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.pdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdb.Pdb;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdb.PdbAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdb.PdbChains;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdb.PdbMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.pdb.PdbResolution;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PdbImpl
extends DatabaseCrossReferenceImpl
implements Pdb,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PDB;
    private long id = 0L;
    private PdbAccessionNumber pdbAccessionNumber = DefaultXRefFactory.getInstance().buildPdbAccessionNumber("");
    private PdbMethod pdbMethod = DefaultXRefFactory.getInstance().buildPdbMethod("");
    private PdbResolution pdbResolution = DefaultXRefFactory.getInstance().buildPdbResolution("");
    private PdbChains pdbChains = DefaultXRefFactory.getInstance().buildPdbChains("");

    public PdbImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPdbAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PdbImpl(PdbImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPdbAccessionNumber()) {
            this.setPdbAccessionNumber(toCopy.getPdbAccessionNumber());
        }
        if (toCopy.hasPdbMethod()) {
            this.setPdbMethod(toCopy.getPdbMethod());
        }
        if (toCopy.hasPdbResolution()) {
            this.setPdbResolution(toCopy.getPdbResolution());
        }
        if (toCopy.hasPdbChains()) {
            this.setPdbChains(toCopy.getPdbChains());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdbImpl)) {
            return false;
        }
        PdbImpl myClass = (PdbImpl)o;
        if (!this.pdbAccessionNumber.equals(myClass.getPdbAccessionNumber())) {
            return false;
        }
        if (!this.pdbMethod.equals(myClass.getPdbMethod())) {
            return false;
        }
        if (!this.pdbResolution.equals(myClass.getPdbResolution())) {
            return false;
        }
        return this.pdbChains.equals(myClass.getPdbChains());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pdbAccessionNumber != null ? this.pdbAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pdbMethod != null ? this.pdbMethod.hashCode() : 0);
        result = 29 * result + (this.pdbResolution != null ? this.pdbResolution.hashCode() : 0);
        result = 29 * result + (this.pdbChains != null ? this.pdbChains.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pdbAccessionNumber + ":" + this.pdbMethod + ":" + this.pdbResolution + ":" + this.pdbChains + ";";
    }

    @Override
    public PdbAccessionNumber getPdbAccessionNumber() {
        return this.pdbAccessionNumber;
    }

    @Override
    public void setPdbAccessionNumber(PdbAccessionNumber pdbAccessionNumber) {
        if (pdbAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pdbAccessionNumber = pdbAccessionNumber;
    }

    @Override
    public boolean hasPdbAccessionNumber() {
        return !this.pdbAccessionNumber.getValue().equals("");
    }

    @Override
    public PdbMethod getPdbMethod() {
        return this.pdbMethod;
    }

    @Override
    public void setPdbMethod(PdbMethod pdbMethod) {
        if (pdbMethod == null) {
            throw new IllegalArgumentException();
        }
        this.pdbMethod = pdbMethod;
    }

    @Override
    public boolean hasPdbMethod() {
        return !this.pdbMethod.getValue().equals("");
    }

    @Override
    public PdbResolution getPdbResolution() {
        return this.pdbResolution;
    }

    @Override
    public void setPdbResolution(PdbResolution pdbResolution) {
        if (pdbResolution == null) {
            throw new IllegalArgumentException();
        }
        this.pdbResolution = pdbResolution;
    }

    @Override
    public boolean hasPdbResolution() {
        return !this.pdbResolution.getValue().equals("");
    }

    @Override
    public PdbChains getPdbChains() {
        return this.pdbChains;
    }

    @Override
    public void setPdbChains(PdbChains pdbChains) {
        if (pdbChains == null) {
            throw new IllegalArgumentException();
        }
        this.pdbChains = pdbChains;
    }

    @Override
    public boolean hasPdbChains() {
        return !this.pdbChains.getValue().equals("");
    }
}

