/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.panther;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.panther.Panther;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.panther.PantherAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.panther.PantherDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.panther.PantherHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class PantherImpl
extends DatabaseCrossReferenceImpl
implements Panther,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.PANTHER;
    private long id = 0L;
    private PantherAccessionNumber pantherAccessionNumber = DefaultXRefFactory.getInstance().buildPantherAccessionNumber("");
    private PantherDescription pantherDescription = DefaultXRefFactory.getInstance().buildPantherDescription("");
    private PantherHitNumber pantherHitNumber = DefaultXRefFactory.getInstance().buildPantherHitNumber("");

    public PantherImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getPantherAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public PantherImpl(PantherImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasPantherAccessionNumber()) {
            this.setPantherAccessionNumber(toCopy.getPantherAccessionNumber());
        }
        if (toCopy.hasPantherDescription()) {
            this.setPantherDescription(toCopy.getPantherDescription());
        }
        if (toCopy.hasPantherHitNumber()) {
            this.setPantherHitNumber(toCopy.getPantherHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof PantherImpl)) {
            return false;
        }
        PantherImpl myClass = (PantherImpl)o;
        if (!this.pantherAccessionNumber.equals(myClass.getPantherAccessionNumber())) {
            return false;
        }
        if (!this.pantherDescription.equals(myClass.getPantherDescription())) {
            return false;
        }
        return this.pantherHitNumber.equals(myClass.getPantherHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.pantherAccessionNumber != null ? this.pantherAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.pantherDescription != null ? this.pantherDescription.hashCode() : 0);
        result = 29 * result + (this.pantherHitNumber != null ? this.pantherHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.pantherAccessionNumber + ":" + this.pantherDescription + ":" + this.pantherHitNumber + ";";
    }

    @Override
    public PantherAccessionNumber getPantherAccessionNumber() {
        return this.pantherAccessionNumber;
    }

    @Override
    public void setPantherAccessionNumber(PantherAccessionNumber pantherAccessionNumber) {
        if (pantherAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pantherAccessionNumber = pantherAccessionNumber;
    }

    @Override
    public boolean hasPantherAccessionNumber() {
        return !this.pantherAccessionNumber.getValue().equals("");
    }

    @Override
    public PantherDescription getPantherDescription() {
        return this.pantherDescription;
    }

    @Override
    public void setPantherDescription(PantherDescription pantherDescription) {
        if (pantherDescription == null) {
            throw new IllegalArgumentException();
        }
        this.pantherDescription = pantherDescription;
    }

    @Override
    public boolean hasPantherDescription() {
        return !this.pantherDescription.getValue().equals("");
    }

    @Override
    public PantherHitNumber getPantherHitNumber() {
        return this.pantherHitNumber;
    }

    @Override
    public void setPantherHitNumber(PantherHitNumber pantherHitNumber) {
        if (pantherHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.pantherHitNumber = pantherHitNumber;
    }

    @Override
    public boolean hasPantherHitNumber() {
        return !this.pantherHitNumber.getValue().equals("");
    }
}

