/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.orthodb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orthodb.OrthoDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orthodb.OrthoDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orthodb.OrthoDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class OrthoDBImpl
extends DatabaseCrossReferenceImpl
implements OrthoDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ORTHODB;
    private long id = 0L;
    private OrthoDBAccessionNumber orthoDBAccessionNumber = DefaultXRefFactory.getInstance().buildOrthoDBAccessionNumber("");
    private OrthoDBDescription orthoDBDescription = DefaultXRefFactory.getInstance().buildOrthoDBDescription("");

    public OrthoDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getOrthoDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public OrthoDBImpl(OrthoDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasOrthoDBAccessionNumber()) {
            this.setOrthoDBAccessionNumber(toCopy.getOrthoDBAccessionNumber());
        }
        if (toCopy.hasOrthoDBDescription()) {
            this.setOrthoDBDescription(toCopy.getOrthoDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrthoDBImpl)) {
            return false;
        }
        OrthoDBImpl myClass = (OrthoDBImpl)o;
        if (!this.orthoDBAccessionNumber.equals(myClass.getOrthoDBAccessionNumber())) {
            return false;
        }
        return this.orthoDBDescription.equals(myClass.getOrthoDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.orthoDBAccessionNumber != null ? this.orthoDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.orthoDBDescription != null ? this.orthoDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.orthoDBAccessionNumber + ":" + this.orthoDBDescription + ";";
    }

    @Override
    public OrthoDBAccessionNumber getOrthoDBAccessionNumber() {
        return this.orthoDBAccessionNumber;
    }

    @Override
    public void setOrthoDBAccessionNumber(OrthoDBAccessionNumber orthoDBAccessionNumber) {
        if (orthoDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.orthoDBAccessionNumber = orthoDBAccessionNumber;
    }

    @Override
    public boolean hasOrthoDBAccessionNumber() {
        return !this.orthoDBAccessionNumber.getValue().equals("");
    }

    @Override
    public OrthoDBDescription getOrthoDBDescription() {
        return this.orthoDBDescription;
    }

    @Override
    public void setOrthoDBDescription(OrthoDBDescription orthoDBDescription) {
        if (orthoDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.orthoDBDescription = orthoDBDescription;
    }

    @Override
    public boolean hasOrthoDBDescription() {
        return !this.orthoDBDescription.getValue().equals("");
    }
}

