/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.orphanet;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orphanet.Orphanet;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orphanet.OrphanetAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.orphanet.OrphanetDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class OrphanetImpl
extends DatabaseCrossReferenceImpl
implements Orphanet,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ORPHANET;
    private long id = 0L;
    private OrphanetAccessionNumber orphanetAccessionNumber = DefaultXRefFactory.getInstance().buildOrphanetAccessionNumber("");
    private OrphanetDescription orphanetDescription = DefaultXRefFactory.getInstance().buildOrphanetDescription("");

    public OrphanetImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getOrphanetAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public OrphanetImpl(OrphanetImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasOrphanetAccessionNumber()) {
            this.setOrphanetAccessionNumber(toCopy.getOrphanetAccessionNumber());
        }
        if (toCopy.hasOrphanetDescription()) {
            this.setOrphanetDescription(toCopy.getOrphanetDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrphanetImpl)) {
            return false;
        }
        OrphanetImpl myClass = (OrphanetImpl)o;
        if (!this.orphanetAccessionNumber.equals(myClass.getOrphanetAccessionNumber())) {
            return false;
        }
        return this.orphanetDescription.equals(myClass.getOrphanetDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.orphanetAccessionNumber != null ? this.orphanetAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.orphanetDescription != null ? this.orphanetDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.orphanetAccessionNumber + ":" + this.orphanetDescription + ";";
    }

    @Override
    public OrphanetAccessionNumber getOrphanetAccessionNumber() {
        return this.orphanetAccessionNumber;
    }

    @Override
    public void setOrphanetAccessionNumber(OrphanetAccessionNumber orphanetAccessionNumber) {
        if (orphanetAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.orphanetAccessionNumber = orphanetAccessionNumber;
    }

    @Override
    public boolean hasOrphanetAccessionNumber() {
        return !this.orphanetAccessionNumber.getValue().equals("");
    }

    @Override
    public OrphanetDescription getOrphanetDescription() {
        return this.orphanetDescription;
    }

    @Override
    public void setOrphanetDescription(OrphanetDescription orphanetDescription) {
        if (orphanetDescription == null) {
            throw new IllegalArgumentException();
        }
        this.orphanetDescription = orphanetDescription;
    }

    @Override
    public boolean hasOrphanetDescription() {
        return !this.orphanetDescription.getValue().equals("");
    }
}

