/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.oma;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.oma.Oma;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.oma.OmaAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.oma.OmaGroupFingerprint;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class OmaImpl
extends DatabaseCrossReferenceImpl
implements Oma,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.OMA;
    private long id = 0L;
    private OmaAccessionNumber omaAccessionNumber = DefaultXRefFactory.getInstance().buildOmaAccessionNumber("");
    private OmaGroupFingerprint omaGroupFingerprint = DefaultXRefFactory.getInstance().buildOmaGroupFingerprint("");

    public OmaImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getOmaAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public OmaImpl(OmaImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasOmaAccessionNumber()) {
            this.setOmaAccessionNumber(toCopy.getOmaAccessionNumber());
        }
        if (toCopy.hasOmaGroupFingerprint()) {
            this.setOmaGroupFingerprint(toCopy.getOmaGroupFingerprint());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OmaImpl)) {
            return false;
        }
        OmaImpl myClass = (OmaImpl)o;
        if (!this.omaAccessionNumber.equals(myClass.getOmaAccessionNumber())) {
            return false;
        }
        return this.omaGroupFingerprint.equals(myClass.getOmaGroupFingerprint());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.omaAccessionNumber != null ? this.omaAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.omaGroupFingerprint != null ? this.omaGroupFingerprint.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.omaAccessionNumber + ":" + this.omaGroupFingerprint + ";";
    }

    @Override
    public OmaAccessionNumber getOmaAccessionNumber() {
        return this.omaAccessionNumber;
    }

    @Override
    public void setOmaAccessionNumber(OmaAccessionNumber omaAccessionNumber) {
        if (omaAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.omaAccessionNumber = omaAccessionNumber;
    }

    @Override
    public boolean hasOmaAccessionNumber() {
        return !this.omaAccessionNumber.getValue().equals("");
    }

    @Override
    public OmaGroupFingerprint getOmaGroupFingerprint() {
        return this.omaGroupFingerprint;
    }

    @Override
    public void setOmaGroupFingerprint(OmaGroupFingerprint omaGroupFingerprint) {
        if (omaGroupFingerprint == null) {
            throw new IllegalArgumentException();
        }
        this.omaGroupFingerprint = omaGroupFingerprint;
    }

    @Override
    public boolean hasOmaGroupFingerprint() {
        return !this.omaGroupFingerprint.getValue().equals("");
    }
}

