/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ogp;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ogp.Ogp;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ogp.OgpAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ogp.OgpDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class OgpImpl
extends DatabaseCrossReferenceImpl
implements Ogp,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.OGP;
    private long id = 0L;
    private OgpAccessionNumber ogpAccessionNumber = DefaultXRefFactory.getInstance().buildOgpAccessionNumber("");
    private OgpDescription ogpDescription = DefaultXRefFactory.getInstance().buildOgpDescription("");

    public OgpImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getOgpAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public OgpImpl(OgpImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasOgpAccessionNumber()) {
            this.setOgpAccessionNumber(toCopy.getOgpAccessionNumber());
        }
        if (toCopy.hasOgpDescription()) {
            this.setOgpDescription(toCopy.getOgpDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OgpImpl)) {
            return false;
        }
        OgpImpl myClass = (OgpImpl)o;
        if (!this.ogpAccessionNumber.equals(myClass.getOgpAccessionNumber())) {
            return false;
        }
        return this.ogpDescription.equals(myClass.getOgpDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ogpAccessionNumber != null ? this.ogpAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.ogpDescription != null ? this.ogpDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ogpAccessionNumber + ":" + this.ogpDescription + ";";
    }

    @Override
    public OgpAccessionNumber getOgpAccessionNumber() {
        return this.ogpAccessionNumber;
    }

    @Override
    public void setOgpAccessionNumber(OgpAccessionNumber ogpAccessionNumber) {
        if (ogpAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.ogpAccessionNumber = ogpAccessionNumber;
    }

    @Override
    public boolean hasOgpAccessionNumber() {
        return !this.ogpAccessionNumber.getValue().equals("");
    }

    @Override
    public OgpDescription getOgpDescription() {
        return this.ogpDescription;
    }

    @Override
    public void setOgpDescription(OgpDescription ogpDescription) {
        if (ogpDescription == null) {
            throw new IllegalArgumentException();
        }
        this.ogpDescription = ogpDescription;
    }

    @Override
    public boolean hasOgpDescription() {
        return !this.ogpDescription.getValue().equals("");
    }
}

