/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.nmpdr;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nmpdr.Nmpdr;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nmpdr.NmpdrAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nmpdr.NmpdrDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class NmpdrImpl
extends DatabaseCrossReferenceImpl
implements Nmpdr,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.NMPDR;
    private long id = 0L;
    private NmpdrAccessionNumber nmpdrAccessionNumber = DefaultXRefFactory.getInstance().buildNmpdrAccessionNumber("");
    private NmpdrDescription nmpdrDescription = DefaultXRefFactory.getInstance().buildNmpdrDescription("");

    public NmpdrImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getNmpdrAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public NmpdrImpl(NmpdrImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasNmpdrAccessionNumber()) {
            this.setNmpdrAccessionNumber(toCopy.getNmpdrAccessionNumber());
        }
        if (toCopy.hasNmpdrDescription()) {
            this.setNmpdrDescription(toCopy.getNmpdrDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof NmpdrImpl)) {
            return false;
        }
        NmpdrImpl myClass = (NmpdrImpl)o;
        if (!this.nmpdrAccessionNumber.equals(myClass.getNmpdrAccessionNumber())) {
            return false;
        }
        return this.nmpdrDescription.equals(myClass.getNmpdrDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.nmpdrAccessionNumber != null ? this.nmpdrAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.nmpdrDescription != null ? this.nmpdrDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.nmpdrAccessionNumber + ":" + this.nmpdrDescription + ";";
    }

    @Override
    public NmpdrAccessionNumber getNmpdrAccessionNumber() {
        return this.nmpdrAccessionNumber;
    }

    @Override
    public void setNmpdrAccessionNumber(NmpdrAccessionNumber nmpdrAccessionNumber) {
        if (nmpdrAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.nmpdrAccessionNumber = nmpdrAccessionNumber;
    }

    @Override
    public boolean hasNmpdrAccessionNumber() {
        return !this.nmpdrAccessionNumber.getValue().equals("");
    }

    @Override
    public NmpdrDescription getNmpdrDescription() {
        return this.nmpdrDescription;
    }

    @Override
    public void setNmpdrDescription(NmpdrDescription nmpdrDescription) {
        if (nmpdrDescription == null) {
            throw new IllegalArgumentException();
        }
        this.nmpdrDescription = nmpdrDescription;
    }

    @Override
    public boolean hasNmpdrDescription() {
        return !this.nmpdrDescription.getValue().equals("");
    }
}

