/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.nextbio;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nextbio.NextBio;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nextbio.NextBioAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.nextbio.NextBioDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class NextBioImpl
extends DatabaseCrossReferenceImpl
implements NextBio,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.NEXTBIO;
    private long id = 0L;
    private NextBioAccessionNumber nextBioAccessionNumber = DefaultXRefFactory.getInstance().buildNextBioAccessionNumber("");
    private NextBioDescription nextBioDescription = DefaultXRefFactory.getInstance().buildNextBioDescription("");

    public NextBioImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getNextBioAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public NextBioImpl(NextBioImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasNextBioAccessionNumber()) {
            this.setNextBioAccessionNumber(toCopy.getNextBioAccessionNumber());
        }
        if (toCopy.hasNextBioDescription()) {
            this.setNextBioDescription(toCopy.getNextBioDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof NextBioImpl)) {
            return false;
        }
        NextBioImpl myClass = (NextBioImpl)o;
        if (!this.nextBioAccessionNumber.equals(myClass.getNextBioAccessionNumber())) {
            return false;
        }
        return this.nextBioDescription.equals(myClass.getNextBioDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.nextBioAccessionNumber != null ? this.nextBioAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.nextBioDescription != null ? this.nextBioDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.nextBioAccessionNumber + ":" + this.nextBioDescription + ";";
    }

    @Override
    public NextBioAccessionNumber getNextBioAccessionNumber() {
        return this.nextBioAccessionNumber;
    }

    @Override
    public void setNextBioAccessionNumber(NextBioAccessionNumber nextBioAccessionNumber) {
        if (nextBioAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.nextBioAccessionNumber = nextBioAccessionNumber;
    }

    @Override
    public boolean hasNextBioAccessionNumber() {
        return !this.nextBioAccessionNumber.getValue().equals("");
    }

    @Override
    public NextBioDescription getNextBioDescription() {
        return this.nextBioDescription;
    }

    @Override
    public void setNextBioDescription(NextBioDescription nextBioDescription) {
        if (nextBioDescription == null) {
            throw new IllegalArgumentException();
        }
        this.nextBioDescription = nextBioDescription;
    }

    @Override
    public boolean hasNextBioDescription() {
        return !this.nextBioDescription.getValue().equals("");
    }
}

