/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.mypulist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mypulist.MypuList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mypulist.MypuListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mypulist.MypuListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MypuListImpl
extends DatabaseCrossReferenceImpl
implements MypuList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MYPULIST;
    private long id = 0L;
    private MypuListAccessionNumber mypuListAccessionNumber = DefaultXRefFactory.getInstance().buildMypuListAccessionNumber("");
    private MypuListDescription mypuListDescription = DefaultXRefFactory.getInstance().buildMypuListDescription("");

    public MypuListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMypuListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MypuListImpl(MypuListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMypuListAccessionNumber()) {
            this.setMypuListAccessionNumber(toCopy.getMypuListAccessionNumber());
        }
        if (toCopy.hasMypuListDescription()) {
            this.setMypuListDescription(toCopy.getMypuListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MypuListImpl)) {
            return false;
        }
        MypuListImpl myClass = (MypuListImpl)o;
        if (!this.mypuListAccessionNumber.equals(myClass.getMypuListAccessionNumber())) {
            return false;
        }
        return this.mypuListDescription.equals(myClass.getMypuListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.mypuListAccessionNumber != null ? this.mypuListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.mypuListDescription != null ? this.mypuListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.mypuListAccessionNumber + ":" + this.mypuListDescription + ";";
    }

    @Override
    public MypuListAccessionNumber getMypuListAccessionNumber() {
        return this.mypuListAccessionNumber;
    }

    @Override
    public void setMypuListAccessionNumber(MypuListAccessionNumber mypuListAccessionNumber) {
        if (mypuListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.mypuListAccessionNumber = mypuListAccessionNumber;
    }

    @Override
    public boolean hasMypuListAccessionNumber() {
        return !this.mypuListAccessionNumber.getValue().equals("");
    }

    @Override
    public MypuListDescription getMypuListDescription() {
        return this.mypuListDescription;
    }

    @Override
    public void setMypuListDescription(MypuListDescription mypuListDescription) {
        if (mypuListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.mypuListDescription = mypuListDescription;
    }

    @Override
    public boolean hasMypuListDescription() {
        return !this.mypuListDescription.getValue().equals("");
    }
}

