/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.mint;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mint.Mint;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mint.MintAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mint.MintDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MintImpl
extends DatabaseCrossReferenceImpl
implements Mint,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MINT;
    private long id = 0L;
    private MintAccessionNumber mintAccessionNumber = DefaultXRefFactory.getInstance().buildMintAccessionNumber("");
    private MintDescription mintDescription = DefaultXRefFactory.getInstance().buildMintDescription("");

    public MintImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMintAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MintImpl(MintImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMintAccessionNumber()) {
            this.setMintAccessionNumber(toCopy.getMintAccessionNumber());
        }
        if (toCopy.hasMintDescription()) {
            this.setMintDescription(toCopy.getMintDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MintImpl)) {
            return false;
        }
        MintImpl myClass = (MintImpl)o;
        if (!this.mintAccessionNumber.equals(myClass.getMintAccessionNumber())) {
            return false;
        }
        return this.mintDescription.equals(myClass.getMintDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.mintAccessionNumber != null ? this.mintAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.mintDescription != null ? this.mintDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.mintAccessionNumber + ":" + this.mintDescription + ";";
    }

    @Override
    public MintAccessionNumber getMintAccessionNumber() {
        return this.mintAccessionNumber;
    }

    @Override
    public void setMintAccessionNumber(MintAccessionNumber mintAccessionNumber) {
        if (mintAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.mintAccessionNumber = mintAccessionNumber;
    }

    @Override
    public boolean hasMintAccessionNumber() {
        return !this.mintAccessionNumber.getValue().equals("");
    }

    @Override
    public MintDescription getMintDescription() {
        return this.mintDescription;
    }

    @Override
    public void setMintDescription(MintDescription mintDescription) {
        if (mintDescription == null) {
            throw new IllegalArgumentException();
        }
        this.mintDescription = mintDescription;
    }

    @Override
    public boolean hasMintDescription() {
        return !this.mintDescription.getValue().equals("");
    }
}

