/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.mim;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mim.Mim;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mim.MimAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mim.MimDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MimImpl
extends DatabaseCrossReferenceImpl
implements Mim,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MIM;
    private long id = 0L;
    private MimAccessionNumber mimAccessionNumber = DefaultXRefFactory.getInstance().buildMimAccessionNumber("");
    private MimDescription mimDescription = DefaultXRefFactory.getInstance().buildMimDescription("");

    public MimImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMimAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MimImpl(MimImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMimAccessionNumber()) {
            this.setMimAccessionNumber(toCopy.getMimAccessionNumber());
        }
        if (toCopy.hasMimDescription()) {
            this.setMimDescription(toCopy.getMimDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MimImpl)) {
            return false;
        }
        MimImpl myClass = (MimImpl)o;
        if (!this.mimAccessionNumber.equals(myClass.getMimAccessionNumber())) {
            return false;
        }
        return this.mimDescription.equals(myClass.getMimDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.mimAccessionNumber != null ? this.mimAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.mimDescription != null ? this.mimDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.mimAccessionNumber + ":" + this.mimDescription + ";";
    }

    @Override
    public MimAccessionNumber getMimAccessionNumber() {
        return this.mimAccessionNumber;
    }

    @Override
    public void setMimAccessionNumber(MimAccessionNumber mimAccessionNumber) {
        if (mimAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.mimAccessionNumber = mimAccessionNumber;
    }

    @Override
    public boolean hasMimAccessionNumber() {
        return !this.mimAccessionNumber.getValue().equals("");
    }

    @Override
    public MimDescription getMimDescription() {
        return this.mimDescription;
    }

    @Override
    public void setMimDescription(MimDescription mimDescription) {
        if (mimDescription == null) {
            throw new IllegalArgumentException();
        }
        this.mimDescription = mimDescription;
    }

    @Override
    public boolean hasMimDescription() {
        return !this.mimDescription.getValue().equals("");
    }
}

