/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.mgi;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgi.Mgi;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgi.MgiAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgi.MgiDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MgiImpl
extends DatabaseCrossReferenceImpl
implements Mgi,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MGI;
    private long id = 0L;
    private MgiAccessionNumber mgiAccessionNumber = DefaultXRefFactory.getInstance().buildMgiAccessionNumber("");
    private MgiDescription mgiDescription = DefaultXRefFactory.getInstance().buildMgiDescription("");

    public MgiImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMgiAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MgiImpl(MgiImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMgiAccessionNumber()) {
            this.setMgiAccessionNumber(toCopy.getMgiAccessionNumber());
        }
        if (toCopy.hasMgiDescription()) {
            this.setMgiDescription(toCopy.getMgiDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MgiImpl)) {
            return false;
        }
        MgiImpl myClass = (MgiImpl)o;
        if (!this.mgiAccessionNumber.equals(myClass.getMgiAccessionNumber())) {
            return false;
        }
        return this.mgiDescription.equals(myClass.getMgiDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.mgiAccessionNumber != null ? this.mgiAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.mgiDescription != null ? this.mgiDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.mgiAccessionNumber + ":" + this.mgiDescription + ";";
    }

    @Override
    public MgiAccessionNumber getMgiAccessionNumber() {
        return this.mgiAccessionNumber;
    }

    @Override
    public void setMgiAccessionNumber(MgiAccessionNumber mgiAccessionNumber) {
        if (mgiAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.mgiAccessionNumber = mgiAccessionNumber;
    }

    @Override
    public boolean hasMgiAccessionNumber() {
        return !this.mgiAccessionNumber.getValue().equals("");
    }

    @Override
    public MgiDescription getMgiDescription() {
        return this.mgiDescription;
    }

    @Override
    public void setMgiDescription(MgiDescription mgiDescription) {
        if (mgiDescription == null) {
            throw new IllegalArgumentException();
        }
        this.mgiDescription = mgiDescription;
    }

    @Override
    public boolean hasMgiDescription() {
        return !this.mgiDescription.getValue().equals("");
    }
}

