/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.mgd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgd.Mgd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgd.MgdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.mgd.MgdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MgdImpl
extends DatabaseCrossReferenceImpl
implements Mgd,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.MGD;
    private long id = 0L;
    private MgdAccessionNumber mgdAccessionNumber = DefaultXRefFactory.getInstance().buildMgdAccessionNumber("");
    private MgdDescription mgdDescription = DefaultXRefFactory.getInstance().buildMgdDescription("");

    public MgdImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MgdImpl(MgdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMgdAccessionNumber()) {
            this.setMgdAccessionNumber(toCopy.getMgdAccessionNumber());
        }
        if (toCopy.hasMgdDescription()) {
            this.setMgdDescription(toCopy.getMgdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MgdImpl)) {
            return false;
        }
        MgdImpl myClass = (MgdImpl)o;
        if (!this.mgdAccessionNumber.equals(myClass.getMgdAccessionNumber())) {
            return false;
        }
        return this.mgdDescription.equals(myClass.getMgdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.mgdAccessionNumber != null ? this.mgdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.mgdDescription != null ? this.mgdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.mgdAccessionNumber + ":" + this.mgdDescription + ";";
    }

    @Override
    public MgdAccessionNumber getMgdAccessionNumber() {
        return this.mgdAccessionNumber;
    }

    @Override
    public void setMgdAccessionNumber(MgdAccessionNumber mgdAccessionNumber) {
        if (mgdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.mgdAccessionNumber = mgdAccessionNumber;
    }

    @Override
    public boolean hasMgdAccessionNumber() {
        return !this.mgdAccessionNumber.getValue().equals("");
    }

    @Override
    public MgdDescription getMgdDescription() {
        return this.mgdDescription;
    }

    @Override
    public void setMgdDescription(MgdDescription mgdDescription) {
        if (mgdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.mgdDescription = mgdDescription;
    }

    @Override
    public boolean hasMgdDescription() {
        return !this.mgdDescription.getValue().equals("");
    }
}

