/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.merops;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.merops.Merops;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.merops.MeropsAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.merops.MeropsDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MeropsImpl
extends DatabaseCrossReferenceImpl
implements Merops,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MEROPS;
    private long id = 0L;
    private MeropsAccessionNumber meropsAccessionNumber = DefaultXRefFactory.getInstance().buildMeropsAccessionNumber("");
    private MeropsDescription meropsDescription = DefaultXRefFactory.getInstance().buildMeropsDescription("");

    public MeropsImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMeropsAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MeropsImpl(MeropsImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMeropsAccessionNumber()) {
            this.setMeropsAccessionNumber(toCopy.getMeropsAccessionNumber());
        }
        if (toCopy.hasMeropsDescription()) {
            this.setMeropsDescription(toCopy.getMeropsDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeropsImpl)) {
            return false;
        }
        MeropsImpl myClass = (MeropsImpl)o;
        if (!this.meropsAccessionNumber.equals(myClass.getMeropsAccessionNumber())) {
            return false;
        }
        return this.meropsDescription.equals(myClass.getMeropsDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.meropsAccessionNumber != null ? this.meropsAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.meropsDescription != null ? this.meropsDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.meropsAccessionNumber + ":" + this.meropsDescription + ";";
    }

    @Override
    public MeropsAccessionNumber getMeropsAccessionNumber() {
        return this.meropsAccessionNumber;
    }

    @Override
    public void setMeropsAccessionNumber(MeropsAccessionNumber meropsAccessionNumber) {
        if (meropsAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.meropsAccessionNumber = meropsAccessionNumber;
    }

    @Override
    public boolean hasMeropsAccessionNumber() {
        return !this.meropsAccessionNumber.getValue().equals("");
    }

    @Override
    public MeropsDescription getMeropsDescription() {
        return this.meropsDescription;
    }

    @Override
    public void setMeropsDescription(MeropsDescription meropsDescription) {
        if (meropsDescription == null) {
            throw new IllegalArgumentException();
        }
        this.meropsDescription = meropsDescription;
    }

    @Override
    public boolean hasMeropsDescription() {
        return !this.meropsDescription.getValue().equals("");
    }
}

