/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.maizegdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizegdb.MaizeGDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizegdb.MaizeGDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizegdb.MaizeGDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MaizeGDBImpl
extends DatabaseCrossReferenceImpl
implements MaizeGDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MAIZEGDB;
    private long id = 0L;
    private MaizeGDBAccessionNumber maizeGDBAccessionNumber = DefaultXRefFactory.getInstance().buildMaizeGDBAccessionNumber("");
    private MaizeGDBDescription maizeGDBDescription = DefaultXRefFactory.getInstance().buildMaizeGDBDescription("");

    public MaizeGDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMaizeGDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MaizeGDBImpl(MaizeGDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMaizeGDBAccessionNumber()) {
            this.setMaizeGDBAccessionNumber(toCopy.getMaizeGDBAccessionNumber());
        }
        if (toCopy.hasMaizeGDBDescription()) {
            this.setMaizeGDBDescription(toCopy.getMaizeGDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaizeGDBImpl)) {
            return false;
        }
        MaizeGDBImpl myClass = (MaizeGDBImpl)o;
        if (!this.maizeGDBAccessionNumber.equals(myClass.getMaizeGDBAccessionNumber())) {
            return false;
        }
        return this.maizeGDBDescription.equals(myClass.getMaizeGDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.maizeGDBAccessionNumber != null ? this.maizeGDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.maizeGDBDescription != null ? this.maizeGDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.maizeGDBAccessionNumber + ":" + this.maizeGDBDescription + ";";
    }

    @Override
    public MaizeGDBAccessionNumber getMaizeGDBAccessionNumber() {
        return this.maizeGDBAccessionNumber;
    }

    @Override
    public void setMaizeGDBAccessionNumber(MaizeGDBAccessionNumber maizeGDBAccessionNumber) {
        if (maizeGDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.maizeGDBAccessionNumber = maizeGDBAccessionNumber;
    }

    @Override
    public boolean hasMaizeGDBAccessionNumber() {
        return !this.maizeGDBAccessionNumber.getValue().equals("");
    }

    @Override
    public MaizeGDBDescription getMaizeGDBDescription() {
        return this.maizeGDBDescription;
    }

    @Override
    public void setMaizeGDBDescription(MaizeGDBDescription maizeGDBDescription) {
        if (maizeGDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.maizeGDBDescription = maizeGDBDescription;
    }

    @Override
    public boolean hasMaizeGDBDescription() {
        return !this.maizeGDBDescription.getValue().equals("");
    }
}

