/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.maizedb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizedb.MaizeDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizedb.MaizeDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.maizedb.MaizeDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class MaizeDBImpl
extends DatabaseCrossReferenceImpl
implements MaizeDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.MAIZEDB;
    private long id = 0L;
    private MaizeDBAccessionNumber maizeDBAccessionNumber = DefaultXRefFactory.getInstance().buildMaizeDBAccessionNumber("");
    private MaizeDBDescription maizeDBDescription = DefaultXRefFactory.getInstance().buildMaizeDBDescription("");

    public MaizeDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getMaizeDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public MaizeDBImpl(MaizeDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasMaizeDBAccessionNumber()) {
            this.setMaizeDBAccessionNumber(toCopy.getMaizeDBAccessionNumber());
        }
        if (toCopy.hasMaizeDBDescription()) {
            this.setMaizeDBDescription(toCopy.getMaizeDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaizeDBImpl)) {
            return false;
        }
        MaizeDBImpl myClass = (MaizeDBImpl)o;
        if (!this.maizeDBAccessionNumber.equals(myClass.getMaizeDBAccessionNumber())) {
            return false;
        }
        return this.maizeDBDescription.equals(myClass.getMaizeDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.maizeDBAccessionNumber != null ? this.maizeDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.maizeDBDescription != null ? this.maizeDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.maizeDBAccessionNumber + ":" + this.maizeDBDescription + ";";
    }

    @Override
    public MaizeDBAccessionNumber getMaizeDBAccessionNumber() {
        return this.maizeDBAccessionNumber;
    }

    @Override
    public void setMaizeDBAccessionNumber(MaizeDBAccessionNumber maizeDBAccessionNumber) {
        if (maizeDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.maizeDBAccessionNumber = maizeDBAccessionNumber;
    }

    @Override
    public boolean hasMaizeDBAccessionNumber() {
        return !this.maizeDBAccessionNumber.getValue().equals("");
    }

    @Override
    public MaizeDBDescription getMaizeDBDescription() {
        return this.maizeDBDescription;
    }

    @Override
    public void setMaizeDBDescription(MaizeDBDescription maizeDBDescription) {
        if (maizeDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.maizeDBDescription = maizeDBDescription;
    }

    @Override
    public boolean hasMaizeDBDescription() {
        return !this.maizeDBDescription.getValue().equals("");
    }
}

