/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.listilist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.listilist.ListiList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.listilist.ListiListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.listilist.ListiListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ListiListImpl
extends DatabaseCrossReferenceImpl
implements ListiList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.LISTILIST;
    private long id = 0L;
    private ListiListAccessionNumber listiListAccessionNumber = DefaultXRefFactory.getInstance().buildListiListAccessionNumber("");
    private ListiListDescription listiListDescription = DefaultXRefFactory.getInstance().buildListiListDescription("");

    public ListiListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getListiListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ListiListImpl(ListiListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasListiListAccessionNumber()) {
            this.setListiListAccessionNumber(toCopy.getListiListAccessionNumber());
        }
        if (toCopy.hasListiListDescription()) {
            this.setListiListDescription(toCopy.getListiListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListiListImpl)) {
            return false;
        }
        ListiListImpl myClass = (ListiListImpl)o;
        if (!this.listiListAccessionNumber.equals(myClass.getListiListAccessionNumber())) {
            return false;
        }
        return this.listiListDescription.equals(myClass.getListiListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.listiListAccessionNumber != null ? this.listiListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.listiListDescription != null ? this.listiListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.listiListAccessionNumber + ":" + this.listiListDescription + ";";
    }

    @Override
    public ListiListAccessionNumber getListiListAccessionNumber() {
        return this.listiListAccessionNumber;
    }

    @Override
    public void setListiListAccessionNumber(ListiListAccessionNumber listiListAccessionNumber) {
        if (listiListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.listiListAccessionNumber = listiListAccessionNumber;
    }

    @Override
    public boolean hasListiListAccessionNumber() {
        return !this.listiListAccessionNumber.getValue().equals("");
    }

    @Override
    public ListiListDescription getListiListDescription() {
        return this.listiListDescription;
    }

    @Override
    public void setListiListDescription(ListiListDescription listiListDescription) {
        if (listiListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.listiListDescription = listiListDescription;
    }

    @Override
    public boolean hasListiListDescription() {
        return !this.listiListDescription.getValue().equals("");
    }
}

