/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.linkhub;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.linkhub.LinkHub;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.linkhub.LinkHubAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.linkhub.LinkHubDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class LinkHubImpl
extends DatabaseCrossReferenceImpl
implements LinkHub,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.LINKHUB;
    private long id = 0L;
    private LinkHubAccessionNumber linkHubAccessionNumber = DefaultXRefFactory.getInstance().buildLinkHubAccessionNumber("");
    private LinkHubDescription linkHubDescription = DefaultXRefFactory.getInstance().buildLinkHubDescription("");

    public LinkHubImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getLinkHubAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public LinkHubImpl(LinkHubImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasLinkHubAccessionNumber()) {
            this.setLinkHubAccessionNumber(toCopy.getLinkHubAccessionNumber());
        }
        if (toCopy.hasLinkHubDescription()) {
            this.setLinkHubDescription(toCopy.getLinkHubDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkHubImpl)) {
            return false;
        }
        LinkHubImpl myClass = (LinkHubImpl)o;
        if (!this.linkHubAccessionNumber.equals(myClass.getLinkHubAccessionNumber())) {
            return false;
        }
        return this.linkHubDescription.equals(myClass.getLinkHubDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.linkHubAccessionNumber != null ? this.linkHubAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.linkHubDescription != null ? this.linkHubDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.linkHubAccessionNumber + ":" + this.linkHubDescription + ";";
    }

    @Override
    public LinkHubAccessionNumber getLinkHubAccessionNumber() {
        return this.linkHubAccessionNumber;
    }

    @Override
    public void setLinkHubAccessionNumber(LinkHubAccessionNumber linkHubAccessionNumber) {
        if (linkHubAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.linkHubAccessionNumber = linkHubAccessionNumber;
    }

    @Override
    public boolean hasLinkHubAccessionNumber() {
        return !this.linkHubAccessionNumber.getValue().equals("");
    }

    @Override
    public LinkHubDescription getLinkHubDescription() {
        return this.linkHubDescription;
    }

    @Override
    public void setLinkHubDescription(LinkHubDescription linkHubDescription) {
        if (linkHubDescription == null) {
            throw new IllegalArgumentException();
        }
        this.linkHubDescription = linkHubDescription;
    }

    @Override
    public boolean hasLinkHubDescription() {
        return !this.linkHubDescription.getValue().equals("");
    }
}

