/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.leproma;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.leproma.Leproma;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.leproma.LepromaAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.leproma.LepromaDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class LepromaImpl
extends DatabaseCrossReferenceImpl
implements Leproma,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.LEPROMA;
    private long id = 0L;
    private LepromaAccessionNumber lepromaAccessionNumber = DefaultXRefFactory.getInstance().buildLepromaAccessionNumber("");
    private LepromaDescription lepromaDescription = DefaultXRefFactory.getInstance().buildLepromaDescription("");

    public LepromaImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getLepromaAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public LepromaImpl(LepromaImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasLepromaAccessionNumber()) {
            this.setLepromaAccessionNumber(toCopy.getLepromaAccessionNumber());
        }
        if (toCopy.hasLepromaDescription()) {
            this.setLepromaDescription(toCopy.getLepromaDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LepromaImpl)) {
            return false;
        }
        LepromaImpl myClass = (LepromaImpl)o;
        if (!this.lepromaAccessionNumber.equals(myClass.getLepromaAccessionNumber())) {
            return false;
        }
        return this.lepromaDescription.equals(myClass.getLepromaDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.lepromaAccessionNumber != null ? this.lepromaAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.lepromaDescription != null ? this.lepromaDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.lepromaAccessionNumber + ":" + this.lepromaDescription + ";";
    }

    @Override
    public LepromaAccessionNumber getLepromaAccessionNumber() {
        return this.lepromaAccessionNumber;
    }

    @Override
    public void setLepromaAccessionNumber(LepromaAccessionNumber lepromaAccessionNumber) {
        if (lepromaAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.lepromaAccessionNumber = lepromaAccessionNumber;
    }

    @Override
    public boolean hasLepromaAccessionNumber() {
        return !this.lepromaAccessionNumber.getValue().equals("");
    }

    @Override
    public LepromaDescription getLepromaDescription() {
        return this.lepromaDescription;
    }

    @Override
    public void setLepromaDescription(LepromaDescription lepromaDescription) {
        if (lepromaDescription == null) {
            throw new IllegalArgumentException();
        }
        this.lepromaDescription = lepromaDescription;
    }

    @Override
    public boolean hasLepromaDescription() {
        return !this.lepromaDescription.getValue().equals("");
    }
}

