/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.legiolist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.legiolist.LegioList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.legiolist.LegioListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.legiolist.LegioListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class LegioListImpl
extends DatabaseCrossReferenceImpl
implements LegioList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.LEGIOLIST;
    private long id = 0L;
    private LegioListAccessionNumber legioListAccessionNumber = DefaultXRefFactory.getInstance().buildLegioListAccessionNumber("");
    private LegioListDescription legioListDescription = DefaultXRefFactory.getInstance().buildLegioListDescription("");

    public LegioListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getLegioListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public LegioListImpl(LegioListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasLegioListAccessionNumber()) {
            this.setLegioListAccessionNumber(toCopy.getLegioListAccessionNumber());
        }
        if (toCopy.hasLegioListDescription()) {
            this.setLegioListDescription(toCopy.getLegioListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegioListImpl)) {
            return false;
        }
        LegioListImpl myClass = (LegioListImpl)o;
        if (!this.legioListAccessionNumber.equals(myClass.getLegioListAccessionNumber())) {
            return false;
        }
        return this.legioListDescription.equals(myClass.getLegioListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.legioListAccessionNumber != null ? this.legioListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.legioListDescription != null ? this.legioListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.legioListAccessionNumber + ":" + this.legioListDescription + ";";
    }

    @Override
    public LegioListAccessionNumber getLegioListAccessionNumber() {
        return this.legioListAccessionNumber;
    }

    @Override
    public void setLegioListAccessionNumber(LegioListAccessionNumber legioListAccessionNumber) {
        if (legioListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.legioListAccessionNumber = legioListAccessionNumber;
    }

    @Override
    public boolean hasLegioListAccessionNumber() {
        return !this.legioListAccessionNumber.getValue().equals("");
    }

    @Override
    public LegioListDescription getLegioListDescription() {
        return this.legioListDescription;
    }

    @Override
    public void setLegioListDescription(LegioListDescription legioListDescription) {
        if (legioListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.legioListDescription = legioListDescription;
    }

    @Override
    public boolean hasLegioListDescription() {
        return !this.legioListDescription.getValue().equals("");
    }
}

