/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ko;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ko.KO;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ko.KODescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ko.KOIdentifier;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class KOImpl
extends DatabaseCrossReferenceImpl
implements KO,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.KO;
    private long id = 0L;
    private KOIdentifier kOIdentifier = DefaultXRefFactory.getInstance().buildKOIdentifier("");
    private KODescription kODescription = DefaultXRefFactory.getInstance().buildKODescription("");

    public KOImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getKOIdentifier().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public KOImpl(KOImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasKOIdentifier()) {
            this.setKOIdentifier(toCopy.getKOIdentifier());
        }
        if (toCopy.hasKODescription()) {
            this.setKODescription(toCopy.getKODescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof KOImpl)) {
            return false;
        }
        KOImpl myClass = (KOImpl)o;
        if (!this.kOIdentifier.equals(myClass.getKOIdentifier())) {
            return false;
        }
        return this.kODescription.equals(myClass.getKODescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.kOIdentifier != null ? this.kOIdentifier.hashCode() : 0);
        result = 29 * result + (this.kODescription != null ? this.kODescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.kOIdentifier + ":" + this.kODescription + ";";
    }

    @Override
    public KOIdentifier getKOIdentifier() {
        return this.kOIdentifier;
    }

    @Override
    public void setKOIdentifier(KOIdentifier kOIdentifier) {
        if (kOIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.kOIdentifier = kOIdentifier;
    }

    @Override
    public boolean hasKOIdentifier() {
        return !this.kOIdentifier.getValue().equals("");
    }

    @Override
    public KODescription getKODescription() {
        return this.kODescription;
    }

    @Override
    public void setKODescription(KODescription kODescription) {
        if (kODescription == null) {
            throw new IllegalArgumentException();
        }
        this.kODescription = kODescription;
    }

    @Override
    public boolean hasKODescription() {
        return !this.kODescription.getValue().equals("");
    }
}

