/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.kegg;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.kegg.Kegg;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.kegg.KeggAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.kegg.KeggDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class KeggImpl
extends DatabaseCrossReferenceImpl
implements Kegg,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.KEGG;
    private long id = 0L;
    private KeggAccessionNumber keggAccessionNumber = DefaultXRefFactory.getInstance().buildKeggAccessionNumber("");
    private KeggDescription keggDescription = DefaultXRefFactory.getInstance().buildKeggDescription("");

    public KeggImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getKeggAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public KeggImpl(KeggImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasKeggAccessionNumber()) {
            this.setKeggAccessionNumber(toCopy.getKeggAccessionNumber());
        }
        if (toCopy.hasKeggDescription()) {
            this.setKeggDescription(toCopy.getKeggDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeggImpl)) {
            return false;
        }
        KeggImpl myClass = (KeggImpl)o;
        if (!this.keggAccessionNumber.equals(myClass.getKeggAccessionNumber())) {
            return false;
        }
        return this.keggDescription.equals(myClass.getKeggDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.keggAccessionNumber != null ? this.keggAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.keggDescription != null ? this.keggDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.keggAccessionNumber + ":" + this.keggDescription + ";";
    }

    @Override
    public KeggAccessionNumber getKeggAccessionNumber() {
        return this.keggAccessionNumber;
    }

    @Override
    public void setKeggAccessionNumber(KeggAccessionNumber keggAccessionNumber) {
        if (keggAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.keggAccessionNumber = keggAccessionNumber;
    }

    @Override
    public boolean hasKeggAccessionNumber() {
        return !this.keggAccessionNumber.getValue().equals("");
    }

    @Override
    public KeggDescription getKeggDescription() {
        return this.keggDescription;
    }

    @Override
    public void setKeggDescription(KeggDescription keggDescription) {
        if (keggDescription == null) {
            throw new IllegalArgumentException();
        }
        this.keggDescription = keggDescription;
    }

    @Override
    public boolean hasKeggDescription() {
        return !this.keggDescription.getValue().equals("");
    }
}

