/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ipi;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ipi.Ipi;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ipi.IpiAcNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ipi.IpiDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class IpiImpl
extends DatabaseCrossReferenceImpl
implements Ipi,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.IPI;
    private long id = 0L;
    private IpiAcNumber ipiAcNumber = DefaultXRefFactory.getInstance().buildIpiAcNumber("");
    private IpiDescription ipiDescription = DefaultXRefFactory.getInstance().buildIpiDescription("");

    public IpiImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getIpiAcNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public IpiImpl(IpiImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasIpiAcNumber()) {
            this.setIpiAcNumber(toCopy.getIpiAcNumber());
        }
        if (toCopy.hasIpiDescription()) {
            this.setIpiDescription(toCopy.getIpiDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpiImpl)) {
            return false;
        }
        IpiImpl myClass = (IpiImpl)o;
        if (!this.ipiAcNumber.equals(myClass.getIpiAcNumber())) {
            return false;
        }
        return this.ipiDescription.equals(myClass.getIpiDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ipiAcNumber != null ? this.ipiAcNumber.hashCode() : 0);
        result = 29 * result + (this.ipiDescription != null ? this.ipiDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ipiAcNumber + ":" + this.ipiDescription + ";";
    }

    @Override
    public IpiAcNumber getIpiAcNumber() {
        return this.ipiAcNumber;
    }

    @Override
    public void setIpiAcNumber(IpiAcNumber ipiAcNumber) {
        if (ipiAcNumber == null) {
            throw new IllegalArgumentException();
        }
        this.ipiAcNumber = ipiAcNumber;
    }

    @Override
    public boolean hasIpiAcNumber() {
        return !this.ipiAcNumber.getValue().equals("");
    }

    @Override
    public IpiDescription getIpiDescription() {
        return this.ipiDescription;
    }

    @Override
    public void setIpiDescription(IpiDescription ipiDescription) {
        if (ipiDescription == null) {
            throw new IllegalArgumentException();
        }
        this.ipiDescription = ipiDescription;
    }

    @Override
    public boolean hasIpiDescription() {
        return !this.ipiDescription.getValue().equals("");
    }
}

